package io.boxo.ui.dialog

import android.content.Context
import android.graphics.Typeface
import android.text.SpannableString
import android.text.style.StyleSpan
import androidx.appcompat.app.AlertDialog
import androidx.core.content.ContextCompat
import io.boxo.R
import io.boxo.js.params.ActionSheet

internal fun ActionSheet.show(context: Context, onClick: (id: Int) -> Unit) {
    val dialog = AlertDialog.Builder(context).apply {
        setTitle(header)
        val items = list.toMutableList()

        val deleteBtn = items.find { it.role == "destructive" }
        if (deleteBtn != null) {
            items.remove(deleteBtn)
            setNegativeButton(deleteBtn.text) { dialog, _ ->
                dialog.dismiss()
                onClick(deleteBtn.id)
            }
        }
        val cancelBtn = items.find { it.role == "cancel" }
        if (cancelBtn != null) {
            items.remove(cancelBtn)
            setPositiveButton(cancelBtn.text) { dialog, _ ->
                dialog.dismiss()
                onClick(cancelBtn.id)
            }
        }
        val selected = items.find { it.role == "selected" }

        setItems(
            items.map {
                if (it.id == selected?.id) SpannableString(it.text).apply {
                    setSpan(StyleSpan(Typeface.BOLD), 0, it.text.length, 0)
                }
                else it.text
            }.toTypedArray()
        ) { dialog, pos ->
            dialog.dismiss()
            onClick(items[pos].id)
        }
    }.show()
    dialog.getButton(AlertDialog.BUTTON_NEGATIVE)
        .setTextColor(ContextCompat.getColor(context, R.color.boxo_alert_dialog_negative_button))
    dialog.getButton(AlertDialog.BUTTON_POSITIVE)
        .setTextColor(ContextCompat.getColor(context, R.color.boxo_alert_dialog_positive_button))
}