package io.boxo.ui.dialog

import android.content.Context
import androidx.appcompat.app.AlertDialog
import androidx.core.content.ContextCompat
import io.boxo.R
import io.boxo.js.params.Alert

internal fun Alert.show(context: Context, onClick: (requestId: String, buttonId: Int) -> Unit) {
    val negativeButtonColor = ContextCompat.getColor(context, R.color.boxo_alert_dialog_negative_button)
    val positiveButtonColor = ContextCompat.getColor(context, R.color.boxo_alert_dialog_positive_button)
    fun Alert.Item.buttonColor() = if (role == "destructive") negativeButtonColor else positiveButtonColor

    val dialog = AlertDialog.Builder(context).apply {
        setCancelable(false)
        header?.also { setTitle(it) }
        message?.also { setMessage(it) }
        when (buttons.size) {
            0 -> {
                setCancelable(true)
            }
            1 -> {
                val button = buttons.first()
                setPositiveButton(button.text) { _, _ -> onClick(requestId, button.id) }
            }
            2 -> {
                val button1 = buttons[0]
                setNegativeButton(button1.text) { _, _ -> onClick(requestId, button1.id) }
                val button2 = buttons[1]
                setPositiveButton(button2.text) { _, _ -> onClick(requestId, button2.id) }
            }
            else -> {
                val button1 = buttons[0]
                setNegativeButton(button1.text) { _, _ -> onClick(requestId, button1.id) }
                val button2 = buttons[1]
                setNeutralButton(button2.text) { _, _ -> onClick(requestId, button2.id) }
                val button3 = buttons[2]
                setPositiveButton(button3.text) { _, _ -> onClick(requestId, button3.id) }
            }
        }
    }.show()
    when (buttons.size) {
        0 -> {
        }
        1 -> dialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(buttons[0].buttonColor())
        2 -> {
            dialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(buttons[0].buttonColor())
            dialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(buttons[1].buttonColor())
        }
        else -> {
            dialog.getButton(AlertDialog.BUTTON_NEGATIVE).setTextColor(buttons[0].buttonColor())
            dialog.getButton(AlertDialog.BUTTON_NEUTRAL).setTextColor(buttons[1].buttonColor())
            dialog.getButton(AlertDialog.BUTTON_POSITIVE).setTextColor(buttons[2].buttonColor())
        }
    }
}