package io.boxo.ui.dialog

import android.content.res.ColorStateList
import android.graphics.Color
import android.os.Bundle
import android.text.method.LinkMovementMethod
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import androidx.core.text.HtmlCompat
import androidx.core.view.isVisible
import io.boxo.R
import io.boxo.data.models.MiniappSettings
import io.boxo.utils.bindView
import io.boxo.utils.expanded
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.squareup.picasso.Picasso

internal class BoxoAuthRequestDialog(
    private val miniappSettings: MiniappSettings,
) : BottomSheetDialogFragment(R.layout.boxo_dialog_auth_base) {

    private val cancelButton by bindView<View>(R.id.cancel_btn)
    private val miniappLogo by bindView<ImageView>(R.id.miniapp_logo)
    private val termsAndPolicy by bindView<TextView>(R.id.tv_terms_and_policy)
    private val allowButton by bindView<Button>(R.id.ok)
    private val messageTV by bindView<TextView>(R.id.message)
    private val descriptionTV by bindView<TextView>(R.id.description)
    private val userFieldsTV by bindView<TextView>(R.id.user_fields)
    private val userFieldsContainer by bindView<ViewGroup>(R.id.user_fields_container)

    private var cancelListener: (() -> Unit)? = null
    private var allowClickListener: (() -> Unit)? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val miniappInfo = miniappSettings.miniappInfo
        val hostappInfo = miniappSettings.hostappInfo
        if (miniappInfo.logo.isNotBlank()) {
            Picasso.get().load(miniappInfo.logo).into(miniappLogo)
        }
        messageTV.text = getString(R.string.boxo_auth_dialog_title, miniappInfo.name)

        if (miniappInfo.requiredFields.isEmpty()) {
            descriptionTV.text = getString(R.string.boxo_auth_dialog_desc)
            userFieldsContainer.isVisible = false
        } else {
            descriptionTV.text = getString(R.string.boxo_auth_dialog_desc_2)
            userFieldsContainer.isVisible = true
            userFieldsTV.text = miniappInfo.requiredFields.joinToString(
                separator = "●  ",
                prefix = "●  "
            ) { it + "\n" }.removeSuffix("\n")
        }

        termsAndPolicy.text =
            HtmlCompat.fromHtml(hostappInfo.consentText, HtmlCompat.FROM_HTML_MODE_COMPACT)
        termsAndPolicy.movementMethod = LinkMovementMethod.getInstance()
        cancelButton.setOnClickListener { dialog?.cancel() }
        dialog?.setOnCancelListener { cancelListener?.invoke() }
        allowButton.setOnClickListener { allowClickListener?.invoke() }
        if (miniappSettings.colors.primaryColor.isNotBlank())
            allowButton.backgroundTintList =
                ColorStateList.valueOf(Color.parseColor(miniappSettings.colors.primaryColor))
        expanded()
    }

    fun setOnCancelListener(listener: () -> Unit) {
        cancelListener = listener
    }

    fun setOnAllowClickListener(listener: () -> Unit) {
        allowClickListener = listener
    }
}