package io.boxo.ui.dialog

import android.os.Bundle
import android.view.View
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import io.boxo.R
import io.boxo.data.models.MiniappSettings
import io.boxo.utils.bindView
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.squareup.picasso.Picasso

internal class BoxoErrorDialog(
    private val miniappSettings: MiniappSettings,
    private val message: String,
) : BottomSheetDialogFragment(R.layout.boxo_dialog_error) {
    private val okButton by bindView<Button>(R.id.ok)
    private val messageTV by bindView<TextView>(R.id.message)
    private val logo by bindView<ImageView>(R.id.logo)

    private var cancelListener: (() -> Unit)? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val miniappInfo = miniappSettings.miniappInfo
        if (miniappInfo.logo.isNotBlank()) {
            Picasso.get().load(miniappInfo.logo).into(logo)
        }
        messageTV.text = message
        okButton.setText(R.string.boxo_login_ok)

        dialog?.setOnCancelListener { cancelListener?.invoke() }
        okButton.setOnClickListener { dialog?.cancel() }
    }

    fun setOnCancelListener(listener: () -> Unit) {
        cancelListener = listener
    }
}