package io.boxo.ui.dialog

import android.os.Bundle
import android.view.View
import android.widget.Button
import android.widget.ImageView
import android.widget.TextView
import io.boxo.R
import io.boxo.data.models.MiniappInfo
import io.boxo.utils.bindView
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import com.squareup.picasso.Picasso

internal enum class Permission { CAMERA, LOCATION }

internal class BoxoPermissionDialog(
    private val miniappInfo: MiniappInfo,
    private val permission: Permission
) : BottomSheetDialogFragment(R.layout.boxo_dialog_for_permission) {

    private val dismissButton by bindView<View>(R.id.cancel_btn)
    private val okButton by bindView<Button>(R.id.ok)
    private val logo by bindView<ImageView>(R.id.miniapp_logo)
    private val messageTV by bindView<TextView>(R.id.message)

    private var dismissClickListener: (() -> Unit)? = null
    private var okClickListener: (() -> Unit)? = null

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        if (miniappInfo.logo.isNotBlank()) {
            Picasso.get().load(miniappInfo.logo).into(logo)
        }
        messageTV.text = when (permission) {
            Permission.CAMERA ->
                String.format(
                    requireContext().getString(R.string.boxo_sdk_permission_camera_text),
                    miniappInfo.name
                )

            Permission.LOCATION ->
                String.format(
                    requireContext().getString(R.string.boxo_sdk_permission_location_text),
                    miniappInfo.name
                )
        }
        okButton.setOnClickListener {
            okClickListener?.invoke()
            dismiss()
        }
        dismissButton.setOnClickListener { dialog?.cancel() }
        dialog?.setOnCancelListener { dismissClickListener?.invoke() }
    }

    fun setOnDismissClickListener(listener: () -> Unit): BoxoPermissionDialog {
        dismissClickListener = listener
        return this
    }

    fun setOnOkClickListener(listener: () -> Unit): BoxoPermissionDialog {
        okClickListener = listener
        return this
    }

}