package io.boxo.ui.dialog

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import androidx.annotation.DrawableRes
import androidx.core.content.ContextCompat
import io.boxo.R
import io.boxo.utils.bindView
import io.boxo.utils.expanded
import io.boxo.utils.extensions.show
import com.google.android.material.bottomsheet.BottomSheetDialogFragment


internal class ContextMenuDialog(
    private val style: String = "default",
    private val settings: Boolean,
    private val clearCacheEnabled: Boolean,
    private val aboutPageEnabled: Boolean,
) : BottomSheetDialogFragment() {
    private val aboutBtn by bindView<TextView>(R.id.about_miniapp)
    private val reloadBtn by bindView<TextView>(R.id.reload_miniapp)
    private val clearCacheBtn by bindView<TextView>(R.id.clear_cache)
    private val settingsBtn by bindView<TextView>(R.id.settings)
    private val reportBtn by bindView<TextView>(R.id.report)


    var onDismiss: (() -> Unit)? = null
    var onAboutClick: (() -> Unit)? = null
    var onReloadClick: (() -> Unit)? = null
    var onClearCacheClick: (() -> Unit)? = null
    var onSettingsClick: (() -> Unit)? = null
    var onReportClick: (() -> Unit)? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? =
        inflater.inflate(R.layout.boxo_dialog_context_menu, container, false)

    private fun cancel() {
        dialog?.cancel()
    }

    private fun TextView.setDrawable(@DrawableRes res: Int) {
        setCompoundDrawablesRelativeWithIntrinsicBounds(
            ContextCompat.getDrawable(requireContext(), res),
            null,
            null,
            null
        )
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        dialog?.setOnCancelListener { onDismiss?.invoke() }

        when (style) {
            "style_1" -> {
                aboutBtn.setDrawable(R.drawable.boxo_menu_style1_ic_info)
                reloadBtn.setDrawable(R.drawable.boxo_menu_style1_ic_refresh)
                clearCacheBtn.setDrawable(R.drawable.boxo_menu_style1_ic_clear)
                settingsBtn.setDrawable(R.drawable.boxo_menu_style1_ic_settings)
            }

            else -> {
            }
        }


        aboutBtn.setOnClickListener {
            cancel()
            onAboutClick?.invoke()
        }
        reloadBtn.setOnClickListener {
            cancel()
            onReloadClick?.invoke()
        }
        clearCacheBtn.setOnClickListener {
            cancel()
            onClearCacheClick?.invoke()
        }
        settingsBtn.setOnClickListener {
            cancel()
            onSettingsClick?.invoke()
        }
        reportBtn.setOnClickListener {
            cancel()
            onReportClick?.invoke()
        }
        settingsBtn.show(settings)
        clearCacheBtn.show(clearCacheEnabled)
        aboutBtn.show(aboutPageEnabled)
        expanded()
    }

}