package io.boxo.ui.dialog

import android.os.Bundle
import android.view.View
import io.boxo.R
import io.boxo.utils.bindView
import com.google.android.material.bottomsheet.BottomSheetDialogFragment


internal class ImageTypeDialog : BottomSheetDialogFragment(R.layout.boxo_dialog_file_type) {

    private val camera by bindView<View>(R.id.camera)
    private val file by bindView<View>(R.id.file)
    var onCameraClick = {}
    var onFileClick = {}
    var onDismiss = {}

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        camera.setOnClickListener {
            onCameraClick()
            dismiss()
        }
        file.setOnClickListener {
            onFileClick()
            dismiss()
        }
        dialog?.setOnCancelListener { onDismiss() }
    }
}