package io.boxo.ui.dialog

import android.content.Context
import android.os.CountDownTimer
import android.view.LayoutInflater
import androidx.appcompat.app.AlertDialog
import io.boxo.R

class LoadingDialog(context: Context) : AlertDialog(context) {
    private var timer: CountDownTimer? = null
    private val stopDialog by lazy {
        Builder(context)
            .setCancelable(false)
            .setMessage(R.string.boxo_stop_loading_dialog_msg)
            .setPositiveButton(android.R.string.ok) { _, _ -> dismiss() }
            .create()
    }

    init {
        val view = LayoutInflater.from(context)?.inflate(R.layout.boxo_loading_dialog, null)!!
        setCancelable(false)
        setView(view)
        window?.decorView?.setBackgroundResource(android.R.color.transparent)
    }

    fun show(visible: Boolean) {
        if (visible) show() else dismiss()
    }

    override fun show() {
        super.show()
        timer?.cancel()
        timer = object : CountDownTimer(30 * 1000, 1000) {
            override fun onFinish() {
                runCatching { stopDialog.show() }
            }

            override fun onTick(millisUntilFinished: Long) {}
        }.start()
    }

    override fun dismiss() {
        timer?.cancel()
        stopDialog.dismiss()
        super.dismiss()
    }
}