package io.boxo.ui.gallery

import android.annotation.SuppressLint
import android.app.Activity
import android.content.Context
import android.os.Bundle
import android.view.View
import android.widget.TextView
import androidx.core.view.ViewCompat
import androidx.viewpager2.widget.ViewPager2
import io.boxo.R
import io.boxo.utils.extensions.fullscreen
import io.boxo.utils.extensions.setMarginTop
import io.boxo.utils.extensions.setMiniappLocale

internal class GalleryActivity : Activity() {

    private var success = false

    @SuppressLint("SetTextI18n")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.boxo_activity_gallery)
        fullscreen()
        val viewPager = findViewById<ViewPager2>(R.id.view_pager)
        val indicator = findViewById<TextView>(R.id.indicator)
        val backBtn = findViewById<View>(R.id.back_btn)
        ViewCompat.setOnApplyWindowInsetsListener(backBtn) { _, insets ->
            backBtn?.setMarginTop(insets.systemWindowInsetTop)
            insets.consumeSystemWindowInsets()
        }

        val items = intent.getStringArrayListExtra("images") ?: emptyList<String>()
        indicator.text = "1/${items.size}"
        viewPager.adapter = GalleryViewPagerAdapter(items) { success = true }
        viewPager.registerOnPageChangeCallback(object : ViewPager2.OnPageChangeCallback() {
            override fun onPageSelected(position: Int) {
                indicator.text = "${position + 1}/${items.size}"
            }
        })
        backBtn.setOnClickListener { finish() }
    }

    override fun attachBaseContext(newBase: Context?) {
        setMiniappLocale()
        super.attachBaseContext(newBase)
    }

    override fun finish() {
        setResult(if (success) RESULT_OK else RESULT_CANCELED)
        super.finish()
    }
}