package io.boxo.ui.gallery

import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ProgressBar
import androidx.recyclerview.widget.RecyclerView
import io.boxo.R
import com.squareup.picasso.Callback
import com.squareup.picasso.Picasso
import io.boxo.ui.gallery.view.PhotoView

internal class GalleryViewPagerAdapter(
    private val items: List<String>,
    private val onLoadSuccess: () -> Unit
) :
    RecyclerView.Adapter<GalleryViewPagerAdapter.ViewHolder>() {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(parent.context)
                .inflate(R.layout.boxo_item_gallery_image, parent, false)
        )
    }

    override fun getItemCount() = items.size

    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.bind(items[position])
    }

    inner class ViewHolder(view: View) : RecyclerView.ViewHolder(view) {
        private val photoView = view.findViewById<PhotoView>(R.id.photo_view)
        private val progressBar = view.findViewById<ProgressBar>(R.id.progressbar)
        private val retryBtn = view.findViewById<Button>(R.id.retry_btn)
        fun bind(url: String) {
            progressBar.visibility = View.VISIBLE
            retryBtn.visibility = View.GONE
            if (url.isNotBlank())
                Picasso.get().load(url)
                    .into(photoView, object : Callback {
                        override fun onSuccess() {
                            progressBar.visibility = View.GONE
                            onLoadSuccess()
                        }

                        override fun onError(e: Exception?) {
                            progressBar.visibility = View.GONE
                            retryBtn.visibility = View.VISIBLE
                            retryBtn.setOnClickListener { bind(url) }
                        }
                    })
        }
    }
}