package io.boxo.ui.main

import android.content.ComponentName
import android.content.Context
import android.net.Uri
import androidx.browser.customtabs.CustomTabsClient
import androidx.browser.customtabs.CustomTabsIntent
import androidx.browser.customtabs.CustomTabsServiceConnection
import androidx.browser.customtabs.CustomTabsSession

internal class BoxoChromeCustomTab(val context: Context) {
    private var client: CustomTabsClient? = null
    private var customTabsSession: CustomTabsSession? = null
    private val CUSTOM_TAB_PACKAGE_NAME = "com.android.chrome"
    private var customTabsServiceConnection: CustomTabsServiceConnection = object : CustomTabsServiceConnection() {
        override fun onCustomTabsServiceConnected(name: ComponentName, customTabsClient: CustomTabsClient) {
            client = customTabsClient
            client?.warmup(0L)
            customTabsSession = client?.newSession(null)
        }

        override fun onServiceDisconnected(name: ComponentName) {
            client = null
        }
    }

    init {
        CustomTabsClient.bindCustomTabsService(context, CUSTOM_TAB_PACKAGE_NAME, customTabsServiceConnection)
    }

    fun openExternalPage(url: String) {
        val customTabsIntent = CustomTabsIntent.Builder(customTabsSession)
            .setUrlBarHidingEnabled(true)
            .setShowTitle(false)
            .build()
        customTabsIntent.launchUrl(context, Uri.parse(url))
    }

    fun destroy() {
        context.unbindService(customTabsServiceConnection)
    }
}