package io.boxo.ui.main.states

internal class LoginState(
    val state: State,
    val message: String = "",
    val data: String = "{}"
) {
    companion object {
        fun idle() = LoginState(State.IDLE)
        fun loading() = LoginState(State.LOADING)
        fun error(message: String) = LoginState(State.ERROR, message)
        fun error(message: String, data: String) = LoginState(State.ERROR, message, data)
        fun success(data: String) = LoginState(State.SUCCESS, data = data)
    }

    enum class State {
        IDLE,
        LOADING,
        ERROR,
        SUCCESS
    }
}