package io.boxo.ui.main.states

internal class SettingsState(
    val state: State,
    val message: String = ""
) {
    companion object {
        fun loading() = SettingsState(State.LOADING_MINIAPP_SETTINGS)
        fun internetError() = SettingsState(State.INTERNET_ERROR)
        fun defaultError() = SettingsState(State.DEFAULT_ERROR)
        fun notAvailableError(message: String = "") = SettingsState(State.NOT_AVAILABLE_ERROR, message)
        fun success() = SettingsState(State.SUCCESS)
    }

    enum class State {
        LOADING_MINIAPP_SETTINGS,
        INTERNET_ERROR,
        DEFAULT_ERROR,
        NOT_AVAILABLE_ERROR,
        SUCCESS
    }
}