package io.boxo.ui.view

import android.content.Context
import android.content.res.ColorStateList
import android.graphics.Color
import android.util.AttributeSet
import android.view.LayoutInflater
import android.view.View
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.TextView
import io.boxo.R
import io.boxo.js.params.TabBar
import com.squareup.picasso.Picasso

internal class BottomTabItem : LinearLayout {

    companion object {
        fun initView(
            context: Context,
            tab: TabBar.Tab,
            onClick: (BottomTabItem) -> Unit
        ): BottomTabItem {
            val view = LayoutInflater.from(context)
                .inflate(R.layout.boxo_bottom_tab_item, null) as BottomTabItem
            view.init(tab, onClick)
            return view
        }
    }

    constructor(context: Context) : super(context)

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs)

    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    )

    private var _tabId: Int = 0
    val tabId get() = _tabId

    private var image: ImageView? = null
    private var title: TextView? = null
    private var badgeDot: View? = null
    private var badgeValue: TextView? = null

    private var activeColor = Color.BLACK
    private var inactiveColor = Color.GRAY

    private fun init(tab: TabBar.Tab, onClick: (BottomTabItem) -> Unit) {
        _tabId = tab.tabId
        image = findViewById(R.id.tab_icon)
        title = findViewById(R.id.tab_name)
        badgeDot = findViewById(R.id.tab_badge_dot)
        badgeValue = findViewById(R.id.tab_badge_value)
        layoutParams = LayoutParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT, 1f)
        title?.text = tab.tabName
        setOnClickListener { onClick.invoke(it as BottomTabItem) }
        if (tab.tabIcon.isNotEmpty()) {
            Picasso.get().load(tab.tabIcon).into(image)
        }
    }

    fun setOptions(options: TabBar.Options) {
        options.color?.also { inactiveColor = Color.parseColor(it) }
        options.selectedColor?.also { activeColor = Color.parseColor(it) }
    }

    fun setState(state: Boolean) {
        if (state) enable() else disable()
    }

    private fun enable() {
        title?.setTextColor(activeColor)
        image?.setColorFilter(activeColor)
    }

    private fun disable() {
        title?.setTextColor(inactiveColor)
        image?.setColorFilter(inactiveColor)
    }

    fun hideBadge() {
        badgeDot?.visibility = View.GONE
        badgeValue?.visibility = View.GONE
    }

    fun showBadge(badge: TabBar.Badge) {
        if (badge.value.isNullOrEmpty()) {
            badgeDot?.visibility = View.VISIBLE
            badgeValue?.visibility = View.GONE
            badgeDot?.backgroundTintList =
                ColorStateList.valueOf(Color.parseColor(badge.background))
        } else {
            badgeDot?.visibility = View.GONE
            badgeValue?.apply {
                visibility = View.VISIBLE
                backgroundTintList = ColorStateList.valueOf(Color.parseColor(badge.background))
                setTextColor(Color.parseColor(badge.color))
                text = badge.value
            }
        }
    }
}