package io.boxo.ui.view

import android.content.Context
import android.graphics.Color
import android.os.Parcel
import android.os.Parcelable
import android.util.AttributeSet
import android.view.View
import android.widget.FrameLayout
import android.widget.LinearLayout
import io.boxo.R
import io.boxo.js.params.TabBar

internal class BottomTabLayout : FrameLayout {

    var tabClickListener: ((Int) -> Unit)? = null

    private var listOfTabs = mutableListOf<BottomTabItem>()
    private var show: Boolean = false
    private var hasBorder: Boolean = true
    private var activeTab: Int = 0
    private var tabs: Array<TabBar.Tab> = arrayOf()
    private var options: TabBar.Options = TabBar.Options()

    private lateinit var border: View
    private lateinit var container: LinearLayout

    private var tabBar: TabBar? = null

    constructor(context: Context) : super(context) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?) : super(context, attrs) {
        init()
    }

    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(
        context,
        attrs,
        defStyleAttr
    ) {
        init()
    }

    private fun init() {
        inflate(context, R.layout.boxo_bottom_tab_layout, this)
        border = findViewById(R.id.border)
        container = findViewById(R.id.tab_layout)
    }

    fun set(tabBar: TabBar) {
        this.tabBar = this.tabBar?.merge(tabBar) ?: tabBar
        tabBar.options?.also { options = it }
        tabBar.list?.also { tabs = it }
        tabBar.activeTab?.also { activeTab = it }
        tabBar.show?.also { show = it }

        tabBar.list?.also { tabs ->
            container.removeAllViews()
            listOfTabs.clear()
            val weight = 1.0f / tabs.size
            tabs.forEach { tab ->
                val tabItem = BottomTabItem.initView(context, tab, onClick = { bottomTabItem ->
                    tabClickListener?.invoke(bottomTabItem.tabId)
                    listOfTabs.forEach { item ->
                        item.setState(item == bottomTabItem)
                    }
                    activeTab = bottomTabItem.tabId
                })
                tabItem.layoutParams = LinearLayout.LayoutParams(
                    LinearLayout.LayoutParams.MATCH_PARENT,
                    LinearLayout.LayoutParams.WRAP_CONTENT, weight
                )
                tabItem.setOptions(options)
                listOfTabs.add(tabItem)
                container.addView(tabItem)
            }
        }

        tabBar.options?.also { options ->
            listOfTabs.forEach { it.setOptions(options) }
            options.background?.also { color -> setBackgroundColor(Color.parseColor(color)) }
            options.hasBorder?.also { hasBorder = it }
            options.borderColor?.also { border.setBackgroundColor(Color.parseColor(it)) }
        }

        tabBar.badges?.also { badges ->
            listOfTabs.forEach { it.hideBadge() }
            badges.forEach { badge ->
                listOfTabs.find { it.tabId == badge.tabId }?.showBadge(badge)
            }
        }

        visibility = if (show) View.VISIBLE else View.GONE
        border.visibility = if (hasBorder) View.VISIBLE else View.GONE

        listOfTabs.forEach { item ->
            item.setState(item.tabId == activeTab)
        }
    }

    override fun onSaveInstanceState(): Parcelable? {
        val superState: Parcelable? = super.onSaveInstanceState()
        superState?.let {
            val state = SavedState(superState)
            state.tabBar = this.tabBar
            return state
        } ?: run {
            return superState
        }
    }

    override fun onRestoreInstanceState(state: Parcelable?) {
        when (state) {
            is SavedState -> {
                super.onRestoreInstanceState(state.superState)
                this.tabBar = state.tabBar
                tabBar?.let { set(it) }
            }
            else -> {
                super.onRestoreInstanceState(state)
            }
        }
    }

    internal class SavedState : BaseSavedState {
        var tabBar: TabBar? = null

        constructor(superState: Parcelable) : super(superState)

        constructor(source: Parcel) : super(source) {
            tabBar = source.readParcelable(TabBar::class.java.classLoader)
        }

        override fun writeToParcel(parcel: Parcel, flags: Int) {
            super.writeToParcel(parcel, flags)
            parcel.writeParcelable(tabBar, flags)
        }

        companion object CREATOR : Parcelable.Creator<SavedState> {
            override fun createFromParcel(parcel: Parcel): SavedState {
                return SavedState(parcel)
            }

            override fun newArray(size: Int): Array<SavedState?> {
                return newArray(size)
            }
        }
    }
}