package io.boxo.ui.view

import android.content.Context
import android.util.AttributeSet
import android.widget.*
import io.boxo.R
import io.boxo.utils.extensions.bindView
import io.boxo.utils.extensions.hide
import io.boxo.utils.extensions.show

internal class ErrorView : FrameLayout {

    private val errorTitle by bindView<TextView>(R.id.error_title)
    private val errorDescription by bindView<TextView>(R.id.error_description)
    private val boxoLogo by bindView<ImageView>(R.id.boxo_logo)
    private val retryBtn by bindView<Button>(R.id.error_retry_btn)
    private val closeBtn by bindView<Button>(R.id.error_close_btn)
    private val retryProgressBar by bindView<ProgressBar>(R.id.error_retry_progressbar)
    var boxoLogoVisible = false
    private var onClose:()->Unit = {}

    constructor(context: Context) : this(context, null)
    constructor(context: Context, attrs: AttributeSet?) : this(context, attrs, 0)
    constructor(context: Context, attrs: AttributeSet?, defStyleAttr: Int) : super(context, attrs, defStyleAttr) {
        inflate(context, R.layout.boxo_error_container, this)
        closeBtn.setOnClickListener { onClose() }
    }

    fun setOnClose(onClose:()-> Unit) {
        this.onClose = onClose
    }

    fun defaultError(onRetry: () -> Unit) {
        showError(
            context.getString(R.string.boxo_error_view_default_error_title),
            context.getString(R.string.boxo_error_view_default_error_text),
            onRetry
        )
    }

    fun textError(text: String, onRetry: () -> Unit) {
        showError(
            context.getString(R.string.boxo_error_view_default_error_title),
            text,
            onRetry
        )
    }

    fun noInternetError(onRetry: () -> Unit) {
        showError(
            context.getString(R.string.boxo_error_view_internet_error_title),
            context.getString(R.string.boxo_error_view_internet_error_text),
            onRetry
        )
    }

    fun miniappNotAvailableError(onRetry: () -> Unit) {
        showError(
            context.getString(R.string.boxo_error_view_miniapp_not_available_error_title),
            context.getString(R.string.boxo_error_view_miniapp_not_available_error_text),
            onRetry
        )
    }

    private fun showError(title: String, description: String, onRetry: () -> Unit) {
        errorTitle.text = title
        errorDescription.text = description
        show()
        retryBtn.show()
        retryProgressBar.hide()
        retryBtn.setOnClickListener {
            retryBtn.hide()
            retryProgressBar.show()
            onRetry()
        }
        boxoLogo.show(boxoLogoVisible)
    }
}