package io.boxo.utils

import android.content.Intent
import android.os.Build
import android.text.SpannableStringBuilder
import android.text.TextPaint
import android.text.style.ClickableSpan
import android.view.View
import android.webkit.WebResourceRequest
import androidx.annotation.IdRes
import androidx.annotation.RequiresApi
import androidx.core.text.inSpans
import androidx.fragment.app.Fragment
import com.google.android.material.bottomsheet.BottomSheetBehavior
import com.google.android.material.bottomsheet.BottomSheetDialog
import com.google.android.material.bottomsheet.BottomSheetDialogFragment
import org.json.JSONObject

val WebResourceRequest.webUrl
    @RequiresApi(Build.VERSION_CODES.LOLLIPOP)
    get() = if (url.toString().startsWith("intent://")) {
        val intent = Intent.parseUri(url.toString(), Intent.URI_INTENT_SCHEME)
        intent.getStringExtra("browser_fallback_url")
    } else url.toString()

fun <ViewT : View> Fragment.bindView(@IdRes idRes: Int): Lazy<ViewT> {
    return lazy(LazyThreadSafetyMode.NONE) { view!!.findViewById<ViewT>(idRes) }
}

internal fun BottomSheetDialogFragment.expanded() {
    val d = dialog as BottomSheetDialog
    val bottomSheetInternal: View =
        d.findViewById(com.google.android.material.R.id.design_bottom_sheet)!!
    BottomSheetBehavior.from(bottomSheetInternal).apply {
        state = BottomSheetBehavior.STATE_EXPANDED
        skipCollapsed = true
    }
}

internal inline fun SpannableStringBuilder.click(
    crossinline onClick: () -> Unit,
    builderAction: SpannableStringBuilder.() -> Unit
): SpannableStringBuilder = inSpans(object : ClickableSpan() {
    override fun onClick(widget: View) = onClick.invoke()

    override fun updateDrawState(textPaint: TextPaint) {
        textPaint.color = textPaint.linkColor
        textPaint.isUnderlineText = true
    }
}, builderAction = builderAction)


internal fun JSONObject.toMap(): Map<String, Any> {
    val map = hashMapOf<String, Any>()
    keys().forEach { key ->
        map[key] = if (optJSONObject(key) != null)
            getJSONObject(key).toMap()
        else get(key)
    }
    return map
}

internal fun JSONObject.toStringMap(): Map<String, String> {
    val map = hashMapOf<String, String>()
    keys().forEach { key -> map[key] = getString(key) }
    return map
}