package io.boxo.utils.extensions

import android.app.Dialog
import android.view.View
import androidx.annotation.IdRes

fun <ViewT : View> Dialog.bindView(@IdRes idRes: Int): Lazy<ViewT> {
    return lazy(LazyThreadSafetyMode.NONE) { findViewById<ViewT>(idRes) }
}