package io.boxo.utils.extensions

import android.animation.Animator
import android.animation.AnimatorListenerAdapter
import android.content.res.Resources
import android.util.TypedValue
import android.view.View
import android.view.ViewGroup
import androidx.annotation.IdRes

internal fun View.setMarginTop(marginTop: Int) {
    val menuLayoutParams = this.layoutParams as ViewGroup.MarginLayoutParams
    menuLayoutParams.setMargins(0, marginTop, 0, 0)
    this.layoutParams = menuLayoutParams
}

internal fun View.setMargin(left: Int = 0, top: Int = 0, right: Int = 0, bottom: Int = 0) {
    val menuLayoutParams = this.layoutParams as ViewGroup.MarginLayoutParams
    menuLayoutParams.setMargins(left, top, right, bottom)
    this.layoutParams = menuLayoutParams
}

internal fun View.hide() {
    visibility = View.GONE
}

internal fun View.invisible() {
    animate()
        .alpha(0.0f)
        .setDuration(300)
        .setListener(object : AnimatorListenerAdapter() {
            override fun onAnimationEnd(animation: Animator, isReverse: Boolean) {
                super.onAnimationEnd(animation, isReverse)
                runCatching { visibility = View.INVISIBLE }
            }
        })
        .start()
}

internal fun View.show() {
    if(visibility != View.VISIBLE) {
        setAlpha(0.0f)
        visibility = View.VISIBLE
        animate()
            .alpha(1.0f)
            .setDuration(300)
            .start()
    }
}

internal fun View.show(visible: Boolean) {
    visibility = if (visible) View.VISIBLE else View.GONE
}

internal fun <ViewT : View> View.bindView(@IdRes idRes: Int): Lazy<ViewT> {
    return lazy(LazyThreadSafetyMode.NONE) { findViewById<ViewT>(idRes) }
}

internal val Int.toDp: Int
    get() = (this / Resources.getSystem().displayMetrics.density).toInt()
internal val Int.toPx: Int
    get() = (this * Resources.getSystem().displayMetrics.density).toInt()

internal fun View.addBackgroundCircleRipple() = with(TypedValue()) {
    context.theme.resolveAttribute(android.R.attr.selectableItemBackgroundBorderless, this, true)
    setBackgroundResource(resourceId)
}