/*
 * Decompiled with CFR 0.152.
 */
package io.boxo.data.storage;

import android.content.Context;
import android.content.SharedPreferences;
import io.boxo.data.models.MiniappSettings;
import io.boxo.data.models.MiniappSettingsKt;
import io.boxo.data.storage.IBoxoStorage;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0017\u0010\u001a\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0019\u0010\u001d\u001a\u00020\n2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001bR\u001c\u0010 \u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!R\u001c\u0010#\u001a\n \u001f*\u0004\u0018\u00010\"0\"8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0014\u0010'\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lio/boxo/data/storage/BoxoStorage;", "Lio/boxo/data/storage/IBoxoStorage;", "Landroid/content/Context;", "context", "<init>", "(Landroid/content/Context;)V", "", "appId", "Lio/boxo/data/models/MiniappSettings;", "miniappSettings", "", "saveMiniappSettings", "(Ljava/lang/String;Lio/boxo/data/models/MiniappSettings;)V", "getMiniappSettings", "(Ljava/lang/String;)Lio/boxo/data/models/MiniappSettings;", "", "miniappSettingsSavedTime", "(Ljava/lang/String;)J", "token", "saveMiniappToken", "(Ljava/lang/String;Ljava/lang/String;)V", "getMiniappToken", "(Ljava/lang/String;)Ljava/lang/String;", "", "isFirstLaunch", "(Ljava/lang/String;)Z", "miniappLaunched", "(Ljava/lang/String;)V", "clearToken", "clearMiniappData", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "sp", "Landroid/content/SharedPreferences;", "Landroid/content/SharedPreferences$Editor;", "editor", "Landroid/content/SharedPreferences$Editor;", "getGuid", "()Ljava/lang/String;", "guid", "boxo_release"}, xi=48)
public final class BoxoStorage
implements IBoxoStorage {
    private final SharedPreferences sp;
    private final SharedPreferences.Editor editor;

    public BoxoStorage(Context context) {
        BoxoStorage boxoStorage = boxoStorage2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BoxoStorage boxoStorage2 = context.getSharedPreferences("BoxoSDK_Main", 0);
        boxoStorage.sp = boxoStorage2;
        boxoStorage.editor = boxoStorage2.edit();
    }

    @Override
    public String getGuid() {
        String string = this.sp.getString("guid", null);
        if (string == null || StringsKt.isBlank((CharSequence)string)) {
            string = UUID.randomUUID().toString();
            this.editor.putString("guid", string).commit();
        }
        return string;
    }

    @Override
    public void saveMiniappSettings(String string, MiniappSettings miniappSettings) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)miniappSettings, (String)"miniappSettings");
        String string2 = string + "_miniapp_settings";
        ((BoxoStorage)((Object)string2)).editor.putString(string2, miniappSettings.getJson()).putLong(string + "_miniapp_settings_saved_time", System.currentTimeMillis()).commit();
    }

    @Override
    public MiniappSettings getMiniappSettings(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"appId");
        String string2 = ((BoxoStorage)((Object)string2)).sp.getString(string + "_miniapp_settings", null);
        return string2 != null ? MiniappSettingsKt.toMiniappSettings(string2) : null;
    }

    @Override
    public long miniappSettingsSavedTime(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"appId");
        return this.sp.getLong(string + "_miniapp_settings_saved_time", 0L);
    }

    @Override
    public void saveMiniappToken(String string, String string2) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"token");
        this.editor.putString(string + "_self_token", string2).commit();
    }

    @Override
    public String getMiniappToken(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"appId");
        return this.sp.getString(string + "_self_token", null);
    }

    @Override
    public boolean isFirstLaunch(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"appId");
        return this.sp.getBoolean(string + "_is_first_launch", true);
    }

    @Override
    public void miniappLaunched(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"appId");
        this.editor.putBoolean(string + "_is_first_launch", false).commit();
    }

    @Override
    public void clearToken(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"appId");
        this.editor.remove(string + "_self_token").commit();
    }

    @Override
    public void clearMiniappData(String string) {
        if (string == null) {
            return;
        }
        BoxoStorage boxoStorage = this;
        boxoStorage.clearToken(string);
        boxoStorage.editor.remove(string + "_last_state").commit();
    }
}

