/*
 * Decompiled with CFR 0.152.
 */
package io.boxo.ui.dialog;

import android.content.DialogInterface;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Bundle;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.text.HtmlCompat;
import androidx.fragment.app.Fragment;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import com.squareup.picasso.Picasso;
import io.boxo.R;
import io.boxo.data.models.HostappInfo;
import io.boxo.data.models.MiniappSettings;
import io.boxo.ui.dialog.BoxoAuthRequestDialog;
import io.boxo.utils.ExtensionsKt;
import java.util.List;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010/H\u0016J\u0014\u00100\u001a\u00020\r2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0014\u00102\u001a\u00020\r2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\n\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\n\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\n\u001a\u0004\b\u001a\u0010\u0017R\u001b\u0010\u001c\u001a\u00020\u001d8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\n\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010!\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\n\u001a\u0004\b\"\u0010\u0017R\u001b\u0010$\u001a\u00020%8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b(\u0010\n\u001a\u0004\b&\u0010'R\u001b\u0010)\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010\n\u001a\u0004\b*\u0010\u0017\u00a8\u00063"}, d2={"Lio/boxo/ui/dialog/BoxoAuthRequestDialog;", "Lcom/google/android/material/bottomsheet/BottomSheetDialogFragment;", "miniappSettings", "Lio/boxo/data/models/MiniappSettings;", "(Lio/boxo/data/models/MiniappSettings;)V", "allowButton", "Landroid/widget/Button;", "getAllowButton", "()Landroid/widget/Button;", "allowButton$delegate", "Lkotlin/Lazy;", "allowClickListener", "Lkotlin/Function0;", "", "cancelButton", "Landroid/view/View;", "getCancelButton", "()Landroid/view/View;", "cancelButton$delegate", "cancelListener", "descriptionTV", "Landroid/widget/TextView;", "getDescriptionTV", "()Landroid/widget/TextView;", "descriptionTV$delegate", "messageTV", "getMessageTV", "messageTV$delegate", "miniappLogo", "Landroid/widget/ImageView;", "getMiniappLogo", "()Landroid/widget/ImageView;", "miniappLogo$delegate", "termsAndPolicy", "getTermsAndPolicy", "termsAndPolicy$delegate", "userFieldsContainer", "Landroid/view/ViewGroup;", "getUserFieldsContainer", "()Landroid/view/ViewGroup;", "userFieldsContainer$delegate", "userFieldsTV", "getUserFieldsTV", "userFieldsTV$delegate", "onViewCreated", "view", "savedInstanceState", "Landroid/os/Bundle;", "setOnAllowClickListener", "listener", "setOnCancelListener", "boxo_release"})
public final class BoxoAuthRequestDialog
extends BottomSheetDialogFragment {
    private final MiniappSettings miniappSettings;
    private final Lazy cancelButton$delegate;
    private final Lazy miniappLogo$delegate;
    private final Lazy termsAndPolicy$delegate;
    private final Lazy allowButton$delegate;
    private final Lazy messageTV$delegate;
    private final Lazy descriptionTV$delegate;
    private final Lazy userFieldsTV$delegate;
    private final Lazy userFieldsContainer$delegate;
    private Function0<Unit> cancelListener;
    private Function0<Unit> allowClickListener;

    public BoxoAuthRequestDialog(MiniappSettings miniappSettings) {
        BoxoAuthRequestDialog boxoAuthRequestDialog = this;
        Intrinsics.checkNotNullParameter((Object)miniappSettings, (String)"miniappSettings");
        super(R.layout.boxo_dialog_auth_base);
        boxoAuthRequestDialog.miniappSettings = miniappSettings;
        boxoAuthRequestDialog.cancelButton$delegate = ExtensionsKt.bindView((Fragment)boxoAuthRequestDialog, R.id.cancel_btn);
        boxoAuthRequestDialog.miniappLogo$delegate = ExtensionsKt.bindView((Fragment)boxoAuthRequestDialog, R.id.miniapp_logo);
        boxoAuthRequestDialog.termsAndPolicy$delegate = ExtensionsKt.bindView((Fragment)boxoAuthRequestDialog, R.id.tv_terms_and_policy);
        boxoAuthRequestDialog.allowButton$delegate = ExtensionsKt.bindView((Fragment)boxoAuthRequestDialog, R.id.ok);
        boxoAuthRequestDialog.messageTV$delegate = ExtensionsKt.bindView((Fragment)boxoAuthRequestDialog, R.id.message);
        boxoAuthRequestDialog.descriptionTV$delegate = ExtensionsKt.bindView((Fragment)boxoAuthRequestDialog, R.id.description);
        boxoAuthRequestDialog.userFieldsTV$delegate = ExtensionsKt.bindView((Fragment)boxoAuthRequestDialog, R.id.user_fields);
        boxoAuthRequestDialog.userFieldsContainer$delegate = ExtensionsKt.bindView((Fragment)boxoAuthRequestDialog, R.id.user_fields_container);
    }

    private final View getCancelButton() {
        return (View)this.cancelButton$delegate.getValue();
    }

    private final ImageView getMiniappLogo() {
        return (ImageView)this.miniappLogo$delegate.getValue();
    }

    private final TextView getTermsAndPolicy() {
        return (TextView)this.termsAndPolicy$delegate.getValue();
    }

    private final Button getAllowButton() {
        return (Button)this.allowButton$delegate.getValue();
    }

    private final TextView getMessageTV() {
        return (TextView)this.messageTV$delegate.getValue();
    }

    private final TextView getDescriptionTV() {
        return (TextView)this.descriptionTV$delegate.getValue();
    }

    private final TextView getUserFieldsTV() {
        return (TextView)this.userFieldsTV$delegate.getValue();
    }

    private final ViewGroup getUserFieldsContainer() {
        return (ViewGroup)this.userFieldsContainer$delegate.getValue();
    }

    private static final void onViewCreated$lambda$0(BoxoAuthRequestDialog boxoAuthRequestDialog, View view) {
        BoxoAuthRequestDialog boxoAuthRequestDialog2 = boxoAuthRequestDialog;
        Intrinsics.checkNotNullParameter((Object)((Object)boxoAuthRequestDialog2), (String)"this$0");
        boxoAuthRequestDialog = boxoAuthRequestDialog2.getDialog();
        if (boxoAuthRequestDialog != null) {
            boxoAuthRequestDialog.cancel();
        }
    }

    private static final void onViewCreated$lambda$1(BoxoAuthRequestDialog function0, DialogInterface dialogInterface) {
        Function0<Unit> function02 = function0;
        Intrinsics.checkNotNullParameter((Object)function02, (String)"this$0");
        function0 = function02.cancelListener;
        if (function0 != null) {
            function0.invoke();
        }
    }

    private static final void onViewCreated$lambda$2(BoxoAuthRequestDialog function0, View view) {
        Function0<Unit> function02 = function0;
        Intrinsics.checkNotNullParameter((Object)function02, (String)"this$0");
        function0 = function02.allowClickListener;
        if (function0 != null) {
            function0.invoke();
        }
    }

    public void onViewCreated(View object, Bundle object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"view");
        super.onViewCreated(object, (Bundle)object2);
        object = this.miniappSettings.getMiniappInfo();
        object2 = this.miniappSettings.getHostappInfo();
        if (!StringsKt.isBlank((CharSequence)object.getLogo())) {
            Picasso.get().load(object.getLogo()).into(this.getMiniappLogo());
        }
        int n = R.string.boxo_auth_dialog_title;
        String string2 = object.getName();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string2;
        this.getMessageTV().setText((CharSequence)this.getString(n, objectArray2));
        if (object.getRequiredFields().isEmpty()) {
            this.getDescriptionTV().setText((CharSequence)this.getString(R.string.boxo_auth_dialog_desc));
            this.getUserFieldsContainer().setVisibility(8);
        } else {
            this.getDescriptionTV().setText((CharSequence)this.getString(R.string.boxo_auth_dialog_desc_2));
            this.getUserFieldsContainer().setVisibility(0);
            List<String> list = object.getRequiredFields();
            object = onViewCreated.1.INSTANCE;
            this.getUserFieldsTV().setText((CharSequence)StringsKt.removeSuffix((String)CollectionsKt.joinToString$default(list, (CharSequence)"\u25cf  ", (CharSequence)"\u25cf  ", null, (int)0, null, (Function1)object, (int)28, null), (CharSequence)"\n"));
        }
        this.getTermsAndPolicy().setText((CharSequence)HtmlCompat.fromHtml((String)((HostappInfo)object2).getConsentText(), (int)63));
        this.getTermsAndPolicy().setMovementMethod(LinkMovementMethod.getInstance());
        this.getCancelButton().setOnClickListener(arg_0 -> BoxoAuthRequestDialog.onViewCreated$lambda$0(this, arg_0));
        object = this.getDialog();
        if (object != null) {
            object.setOnCancelListener(arg_0 -> BoxoAuthRequestDialog.onViewCreated$lambda$1(this, arg_0));
        }
        this.getAllowButton().setOnClickListener(arg_0 -> BoxoAuthRequestDialog.onViewCreated$lambda$2(this, arg_0));
        if (!StringsKt.isBlank((CharSequence)this.miniappSettings.getColors().getPrimaryColor())) {
            this.getAllowButton().setBackgroundTintList(ColorStateList.valueOf((int)Color.parseColor((String)this.miniappSettings.getColors().getPrimaryColor())));
        }
        ExtensionsKt.expanded(this);
    }

    public final void setOnCancelListener(Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"listener");
        this.cancelListener = function0;
    }

    public final void setOnAllowClickListener(Function0<Unit> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"listener");
        this.allowClickListener = function0;
    }
}

