/*
 * Decompiled with CFR 0.152.
 */
package io.boxo.ui.gallery.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import io.boxo.ui.gallery.view.OnMatrixChangedListener;
import io.boxo.ui.gallery.view.OnOutsidePhotoTapListener;
import io.boxo.ui.gallery.view.OnPhotoTapListener;
import io.boxo.ui.gallery.view.OnScaleChangedListener;
import io.boxo.ui.gallery.view.OnSingleFlingListener;
import io.boxo.ui.gallery.view.OnViewDragListener;
import io.boxo.ui.gallery.view.OnViewTapListener;
import io.boxo.ui.gallery.view.PhotoViewAttacher;

public class PhotoView
extends AppCompatImageView {
    private PhotoViewAttacher attacher;
    private ImageView.ScaleType pendingScaleType;

    public PhotoView(Context context) {
        this(context, null);
    }

    public PhotoView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public PhotoView(Context context, AttributeSet attributeSet, int n) {
        PhotoView photoView = this;
        super(context, attributeSet, n);
        photoView.init();
    }

    private void init() {
        PhotoView photoView = this;
        photoView.attacher = new PhotoViewAttacher((ImageView)this);
        super.setScaleType(ImageView.ScaleType.MATRIX);
        ImageView.ScaleType scaleType = photoView.pendingScaleType;
        if (scaleType != null) {
            this.setScaleType(scaleType);
            this.pendingScaleType = null;
        }
    }

    public PhotoViewAttacher getAttacher() {
        return this.attacher;
    }

    public ImageView.ScaleType getScaleType() {
        return this.attacher.getScaleType();
    }

    public Matrix getImageMatrix() {
        return this.attacher.getImageMatrix();
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.attacher.setOnLongClickListener(onLongClickListener);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.attacher.setOnClickListener(onClickListener);
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        PhotoViewAttacher photoViewAttacher = this.attacher;
        if (photoViewAttacher == null) {
            this.pendingScaleType = scaleType;
        } else {
            photoViewAttacher.setScaleType(scaleType);
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        PhotoView photoView = photoViewAttacher;
        super.setImageDrawable(drawable2);
        PhotoViewAttacher photoViewAttacher = photoView.attacher;
        if (photoViewAttacher != null) {
            photoViewAttacher.update();
        }
    }

    public void setImageResource(int n) {
        PhotoView photoView = photoViewAttacher;
        super.setImageResource(n);
        PhotoViewAttacher photoViewAttacher = photoView.attacher;
        if (photoViewAttacher != null) {
            photoViewAttacher.update();
        }
    }

    public void setImageURI(Uri uri) {
        PhotoView photoView = photoViewAttacher;
        super.setImageURI(uri);
        PhotoViewAttacher photoViewAttacher = photoView.attacher;
        if (photoViewAttacher != null) {
            photoViewAttacher.update();
        }
    }

    public boolean setFrame(int n, int n2, int n3, int n4) {
        boolean bl = super.setFrame(n, n2, n3, n4);
        n = bl ? 1 : 0;
        if (bl) {
            this.attacher.update();
        }
        return n != 0;
    }

    public void setRotationTo(float f) {
        this.attacher.setRotationTo(f);
    }

    public void setRotationBy(float f) {
        this.attacher.setRotationBy(f);
    }

    public void setZoomable(boolean bl) {
        this.attacher.setZoomable(bl);
    }

    public RectF getDisplayRect() {
        return this.attacher.getDisplayRect();
    }

    public float getMinimumScale() {
        return this.attacher.getMinimumScale();
    }

    public float getMediumScale() {
        return this.attacher.getMediumScale();
    }

    public float getMaximumScale() {
        return this.attacher.getMaximumScale();
    }

    public float getScale() {
        return this.attacher.getScale();
    }

    public void setAllowParentInterceptOnEdge(boolean bl) {
        this.attacher.setAllowParentInterceptOnEdge(bl);
    }

    public void setMinimumScale(float f) {
        this.attacher.setMinimumScale(f);
    }

    public void setMediumScale(float f) {
        this.attacher.setMediumScale(f);
    }

    public void setMaximumScale(float f) {
        this.attacher.setMaximumScale(f);
    }

    public void setOnMatrixChangeListener(OnMatrixChangedListener onMatrixChangedListener) {
        this.attacher.setOnMatrixChangeListener(onMatrixChangedListener);
    }

    public void setOnPhotoTapListener(OnPhotoTapListener onPhotoTapListener) {
        this.attacher.setOnPhotoTapListener(onPhotoTapListener);
    }

    public void setOnOutsidePhotoTapListener(OnOutsidePhotoTapListener onOutsidePhotoTapListener) {
        this.attacher.setOnOutsidePhotoTapListener(onOutsidePhotoTapListener);
    }

    public void setOnViewTapListener(OnViewTapListener onViewTapListener) {
        this.attacher.setOnViewTapListener(onViewTapListener);
    }

    public void setOnViewDragListener(OnViewDragListener onViewDragListener) {
        this.attacher.setOnViewDragListener(onViewDragListener);
    }

    public void setScale(float f) {
        this.attacher.setScale(f);
    }

    public void setZoomTransitionDuration(int n) {
        this.attacher.setZoomTransitionDuration(n);
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.attacher.setOnDoubleTapListener(onDoubleTapListener);
    }

    public void setOnScaleChangeListener(OnScaleChangedListener onScaleChangedListener) {
        this.attacher.setOnScaleChangeListener(onScaleChangedListener);
    }

    public void setOnSingleFlingListener(OnSingleFlingListener onSingleFlingListener) {
        this.attacher.setOnSingleFlingListener(onSingleFlingListener);
    }
}

