/*
 * Decompiled with CFR 0.152.
 */
package io.boxo.ui.gallery.view;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import io.boxo.ui.gallery.view.OnGestureListener;
import io.boxo.ui.gallery.view.Util;

class CustomGestureDetector {
    private int mActivePointerId;
    private int mActivePointerIndex;
    private final ScaleGestureDetector mDetector;
    private VelocityTracker mVelocityTracker;
    private boolean mIsDragging;
    private float mLastTouchX;
    private float mLastTouchY;
    private final float mTouchSlop;
    private final float mMinimumVelocity;
    private OnGestureListener mListener;

    public CustomGestureDetector(Context context, OnGestureListener object) {
        ScaleGestureDetector.OnScaleGestureListener onScaleGestureListener;
        CustomGestureDetector customGestureDetector = this;
        OnGestureListener onGestureListener = object;
        CustomGestureDetector customGestureDetector2 = this;
        this.mActivePointerId = -1;
        this.mActivePointerIndex = 0;
        object = ViewConfiguration.get((Context)context);
        customGestureDetector2.mMinimumVelocity = object.getScaledMinimumFlingVelocity();
        customGestureDetector2.mTouchSlop = object.getScaledTouchSlop();
        customGestureDetector.mListener = onGestureListener;
        object = onScaleGestureListener;
        onScaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){
            private float lastFocusX;
            private float lastFocusY = 0.0f;

            public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
                float f = scaleGestureDetector.getScaleFactor();
                if (!Float.isNaN(f) && !Float.isInfinite(f)) {
                    if (f >= 0.0f) {
                        float f2 = f;
                        ScaleGestureDetector scaleGestureDetector2 = scaleGestureDetector;
                        float f3 = scaleGestureDetector2.getFocusX();
                        f = scaleGestureDetector2.getFocusY();
                        float f4 = scaleGestureDetector2.getFocusX() - this.lastFocusX;
                        float f5 = scaleGestureDetector2.getFocusY() - this.lastFocusY;
                        CustomGestureDetector.this.mListener.onScale(f2, f3, f, f4, f5);
                        this.lastFocusX = scaleGestureDetector.getFocusX();
                        this.lastFocusY = scaleGestureDetector.getFocusY();
                    }
                    return true;
                }
                return false;
            }

            public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
                this.lastFocusX = scaleGestureDetector.getFocusX();
                this.lastFocusY = scaleGestureDetector.getFocusY();
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
            }
        };
        customGestureDetector.mDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)object);
    }

    private float getActiveX(MotionEvent motionEvent) {
        try {
            return motionEvent.getX(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getX();
        }
    }

    private float getActiveY(MotionEvent motionEvent) {
        try {
            return motionEvent.getY(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getY();
        }
    }

    private boolean processTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction() & 0xFF) {
            default: {
                break;
            }
            case 6: {
                MotionEvent motionEvent2 = motionEvent;
                int n = Util.getPointerIndex(motionEvent2.getAction());
                if (motionEvent2.getPointerId(n) != this.mActivePointerId) break;
                n = n == 0 ? 1 : 0;
                MotionEvent motionEvent3 = motionEvent;
                this.mActivePointerId = motionEvent3.getPointerId(n);
                this.mLastTouchX = motionEvent3.getX(n);
                this.mLastTouchY = motionEvent3.getY(n);
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker == null) break;
                velocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 2: {
                float f = this.getActiveX(motionEvent);
                float f2 = this.getActiveY(motionEvent);
                float f3 = f - this.mLastTouchX;
                float f4 = f2 - this.mLastTouchY;
                if (!this.mIsDragging) {
                    float f5 = f3;
                    float f6 = f4;
                    boolean bl = Math.sqrt(f5 * f5 + f6 * f6) >= (double)this.mTouchSlop;
                    this.mIsDragging = bl;
                }
                if (!this.mIsDragging) break;
                this.mListener.onDrag(f3, f4);
                this.mLastTouchX = f;
                this.mLastTouchY = f2;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker == null) break;
                velocityTracker.addMovement(motionEvent);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker;
                this.mActivePointerId = -1;
                if (this.mIsDragging && this.mVelocityTracker != null) {
                    float f;
                    this.mLastTouchX = this.getActiveX(motionEvent);
                    this.mLastTouchY = this.getActiveY(motionEvent);
                    this.mVelocityTracker.addMovement(motionEvent);
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float f7 = this.mVelocityTracker.getXVelocity();
                    float f8 = this.mVelocityTracker.getYVelocity();
                    if (Math.max(Math.abs(f), Math.abs(f8)) >= this.mMinimumVelocity) {
                        float f9 = f8;
                        float f10 = f7;
                        f7 = this.mLastTouchX;
                        f8 = this.mLastTouchY;
                        float f11 = -f10;
                        float f12 = -f9;
                        this.mListener.onFling(f7, f8, f11, f12);
                    }
                }
                if ((velocityTracker = this.mVelocityTracker) == null) break;
                velocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 0: {
                VelocityTracker velocityTracker;
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.mVelocityTracker = velocityTracker = VelocityTracker.obtain();
                if (velocityTracker != null) {
                    velocityTracker.addMovement(motionEvent);
                }
                this.mLastTouchX = this.getActiveX(motionEvent);
                this.mLastTouchY = this.getActiveY(motionEvent);
                this.mIsDragging = false;
            }
        }
        int n = this.mActivePointerId;
        if (n == -1) {
            n = 0;
        }
        this.mActivePointerIndex = motionEvent.findPointerIndex(n);
        return true;
    }

    public boolean isScaling() {
        return this.mDetector.isInProgress();
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        MotionEvent motionEvent2;
        CustomGestureDetector customGestureDetector;
        try {
            customGestureDetector = this;
            motionEvent2 = motionEvent;
            this.mDetector.onTouchEvent(motionEvent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return customGestureDetector.processTouchEvent(motionEvent2);
    }
}

