/*
 * Decompiled with CFR 0.152.
 */
package io.boxo.ui.gallery.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import io.boxo.ui.gallery.view.CustomGestureDetector;
import io.boxo.ui.gallery.view.OnGestureListener;
import io.boxo.ui.gallery.view.OnMatrixChangedListener;
import io.boxo.ui.gallery.view.OnOutsidePhotoTapListener;
import io.boxo.ui.gallery.view.OnPhotoTapListener;
import io.boxo.ui.gallery.view.OnScaleChangedListener;
import io.boxo.ui.gallery.view.OnSingleFlingListener;
import io.boxo.ui.gallery.view.OnViewDragListener;
import io.boxo.ui.gallery.view.OnViewTapListener;
import io.boxo.ui.gallery.view.Util;

public class PhotoViewAttacher
implements View.OnTouchListener,
View.OnLayoutChangeListener {
    private static float DEFAULT_MAX_SCALE = 3.0f;
    private static float DEFAULT_MID_SCALE = 1.75f;
    private static float DEFAULT_MIN_SCALE = 1.0f;
    private static int DEFAULT_ZOOM_DURATION = 200;
    private Interpolator mInterpolator;
    private int mZoomDuration;
    private float mMinScale;
    private float mMidScale;
    private float mMaxScale;
    private boolean mAllowParentInterceptOnEdge;
    private boolean mBlockParentIntercept;
    private ImageView mImageView;
    private GestureDetector mGestureDetector;
    private CustomGestureDetector mScaleDragDetector;
    private final Matrix mBaseMatrix;
    private final Matrix mDrawMatrix;
    private final Matrix mSuppMatrix;
    private final RectF mDisplayRect;
    private final float[] mMatrixValues;
    private View.OnClickListener mOnClickListener;
    private View.OnLongClickListener mLongClickListener;
    private FlingRunnable mCurrentFlingRunnable;
    private int mHorizontalScrollEdge;
    private int mVerticalScrollEdge;
    private float mBaseRotation;
    private boolean mZoomEnabled;
    private ImageView.ScaleType mScaleType;
    private OnGestureListener onGestureListener;

    public PhotoViewAttacher(ImageView object) {
        GestureDetector.OnDoubleTapListener onDoubleTapListener;
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener;
        GestureDetector gestureDetector;
        CustomGestureDetector customGestureDetector;
        OnGestureListener onGestureListener;
        RectF rectF;
        Matrix matrix;
        Matrix matrix2;
        Matrix matrix3;
        AccelerateDecelerateInterpolator accelerateDecelerateInterpolator;
        ImageView imageView = object;
        Object object2 = accelerateDecelerateInterpolator;
        accelerateDecelerateInterpolator = new AccelerateDecelerateInterpolator();
        this.mInterpolator = object2;
        this.mZoomDuration = DEFAULT_ZOOM_DURATION;
        this.mMinScale = DEFAULT_MIN_SCALE;
        this.mMidScale = DEFAULT_MID_SCALE;
        this.mMaxScale = DEFAULT_MAX_SCALE;
        this.mAllowParentInterceptOnEdge = true;
        this.mBlockParentIntercept = false;
        object2 = matrix3;
        matrix3 = new Matrix();
        this.mBaseMatrix = object2;
        object2 = matrix2;
        matrix2 = new Matrix();
        this.mDrawMatrix = object2;
        object2 = matrix;
        matrix = new Matrix();
        this.mSuppMatrix = object2;
        object2 = rectF;
        rectF = new RectF();
        this.mDisplayRect = object2;
        this.mMatrixValues = new float[9];
        this.mHorizontalScrollEdge = 2;
        this.mVerticalScrollEdge = 2;
        this.mZoomEnabled = true;
        this.mScaleType = ImageView.ScaleType.FIT_CENTER;
        object2 = onGestureListener;
        onGestureListener = new OnGestureListener(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void onDrag(float f, float f2) {
                if (photoViewAttacher2.PhotoViewAttacher.this.mScaleDragDetector.isScaling()) return;
                1 v0 = photoViewAttacher2;
                v0.PhotoViewAttacher.this.getClass();
                v0.PhotoViewAttacher.this.mSuppMatrix.postTranslate(f, f2);
                v0.PhotoViewAttacher.this.checkAndDisplayMatrix();
                ViewParent viewParent = v0.PhotoViewAttacher.this.mImageView.getParent();
                PhotoViewAttacher photoViewAttacher = v0.PhotoViewAttacher.this;
                if (photoViewAttacher.mAllowParentInterceptOnEdge && !photoViewAttacher.mScaleDragDetector.isScaling()) {
                    PhotoViewAttacher photoViewAttacher2 = photoViewAttacher2.PhotoViewAttacher.this;
                    if (!photoViewAttacher2.mBlockParentIntercept) {
                        int n;
                        int n2 = photoViewAttacher2.mHorizontalScrollEdge;
                        if (!(n2 == 2 || n2 == 0 && f >= 1.0f || n2 == 1 && f <= -1.0f || (n = photoViewAttacher2.mVerticalScrollEdge) == 0 && f2 >= 1.0f) && (n != 1 || !(f2 <= -1.0f)) || viewParent == null) return;
                        viewParent.requestDisallowInterceptTouchEvent(false);
                        return;
                    }
                }
                if (viewParent == null) return;
                viewParent.requestDisallowInterceptTouchEvent(true);
            }

            @Override
            public void onFling(float f, float f2, float f3, float f4) {
                PhotoViewAttacher photoViewAttacher;
                1 v0 = this;
                PhotoViewAttacher photoViewAttacher2 = photoViewAttacher = v0.PhotoViewAttacher.this;
                v0.PhotoViewAttacher.this.mCurrentFlingRunnable = photoViewAttacher2.new FlingRunnable(photoViewAttacher2.mImageView.getContext());
                PhotoViewAttacher photoViewAttacher3 = photoViewAttacher = v0.PhotoViewAttacher.this;
                int n = photoViewAttacher3.getImageViewWidth(photoViewAttacher3.mImageView);
                PhotoViewAttacher photoViewAttacher4 = PhotoViewAttacher.this;
                int n2 = photoViewAttacher4.getImageViewHeight(photoViewAttacher4.mImageView);
                int n3 = (int)f3;
                int n4 = (int)f4;
                photoViewAttacher.mCurrentFlingRunnable.fling(n, n2, n3, n4);
                PhotoViewAttacher photoViewAttacher5 = v0.PhotoViewAttacher.this;
                photoViewAttacher5.mImageView.post((Runnable)photoViewAttacher5.mCurrentFlingRunnable);
            }

            @Override
            public void onScale(float f, float f2, float f3) {
                this.onScale(f, f2, f3, 0.0f, 0.0f);
            }

            @Override
            public void onScale(float f, float f2, float f3, float f4, float f5) {
                PhotoViewAttacher photoViewAttacher = PhotoViewAttacher.this;
                if (!(PhotoViewAttacher.this.getScale() < photoViewAttacher.mMaxScale) && !(f < 1.0f)) {
                    return;
                }
                1 v0 = this;
                photoViewAttacher.getClass();
                float f6 = f;
                v0.PhotoViewAttacher.this.mSuppMatrix.postScale(f6, f6, f2, f3);
                v0.PhotoViewAttacher.this.mSuppMatrix.postTranslate(f4, f5);
                v0.PhotoViewAttacher.this.checkAndDisplayMatrix();
            }
        };
        this.onGestureListener = object2;
        this.mImageView = object;
        imageView.setOnTouchListener((View.OnTouchListener)this);
        imageView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        if (imageView.isInEditMode()) {
            return;
        }
        this.mBaseRotation = 0.0f;
        object2 = customGestureDetector;
        customGestureDetector = new CustomGestureDetector(object.getContext(), this.onGestureListener);
        this.mScaleDragDetector = object2;
        object2 = gestureDetector;
        object = object.getContext();
        GestureDetector.SimpleOnGestureListener simpleOnGestureListener2 = simpleOnGestureListener;
        simpleOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

            public void onLongPress(MotionEvent motionEvent) {
                Object object = object.PhotoViewAttacher.this;
                motionEvent = ((PhotoViewAttacher)object).mLongClickListener;
                if (motionEvent != null) {
                    motionEvent.onLongClick((View)((PhotoViewAttacher)object).mImageView);
                    return;
                }
            }

            public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
                PhotoViewAttacher.this.getClass();
                return false;
            }
        };
        gestureDetector = new GestureDetector((Context)object, (GestureDetector.OnGestureListener)simpleOnGestureListener2);
        this.mGestureDetector = object2;
        object = onDoubleTapListener;
        onDoubleTapListener = new GestureDetector.OnDoubleTapListener(){

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                PhotoViewAttacher photoViewAttacher = PhotoViewAttacher.this;
                View.OnClickListener onClickListener = photoViewAttacher.mOnClickListener;
                if (onClickListener != null) {
                    onClickListener.onClick((View)photoViewAttacher.mImageView);
                }
                photoViewAttacher = PhotoViewAttacher.this.getDisplayRect();
                MotionEvent motionEvent2 = motionEvent;
                float f = motionEvent2.getX();
                float f2 = motionEvent2.getY();
                PhotoViewAttacher.this.getClass();
                if (photoViewAttacher != null) {
                    if (photoViewAttacher.contains(f, f2)) {
                        PhotoViewAttacher photoViewAttacher2 = photoViewAttacher;
                        photoViewAttacher2.width();
                        photoViewAttacher2.height();
                        PhotoViewAttacher.this.getClass();
                        return true;
                    }
                    PhotoViewAttacher.this.getClass();
                }
                return false;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public boolean onDoubleTap(MotionEvent motionEvent) {
                float f;
                float f2;
                block8: {
                    float f3;
                    block7: {
                        try {
                            float f4;
                            f3 = PhotoViewAttacher.this.getScale();
                            MotionEvent motionEvent2 = motionEvent;
                            f2 = motionEvent2.getX();
                            f = motionEvent2.getY();
                            if (!(f4 < PhotoViewAttacher.this.getMediumScale())) break block7;
                            PhotoViewAttacher photoViewAttacher = PhotoViewAttacher.this;
                            photoViewAttacher.setScale(photoViewAttacher.getMediumScale(), f2, f, true);
                            return true;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            return true;
                        }
                    }
                    if (!(f3 >= PhotoViewAttacher.this.getMediumScale())) break block8;
                    if (!(f3 < PhotoViewAttacher.this.getMaximumScale())) break block8;
                    PhotoViewAttacher photoViewAttacher = PhotoViewAttacher.this;
                    photoViewAttacher.setScale(photoViewAttacher.getMaximumScale(), f2, f, true);
                    return true;
                }
                PhotoViewAttacher photoViewAttacher = PhotoViewAttacher.this;
                photoViewAttacher.setScale(photoViewAttacher.getMinimumScale(), f2, f, true);
                return true;
            }

            public boolean onDoubleTapEvent(MotionEvent motionEvent) {
                return false;
            }
        };
        gestureDetector.setOnDoubleTapListener((GestureDetector.OnDoubleTapListener)object);
    }

    private Matrix getDrawMatrix() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mDrawMatrix.set(this.mBaseMatrix);
        photoViewAttacher.mDrawMatrix.postConcat(this.mSuppMatrix);
        return photoViewAttacher.mDrawMatrix;
    }

    private float getValue(Matrix matrix, int n) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[n];
    }

    private void resetMatrix() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.reset();
        photoViewAttacher.setRotationBy(photoViewAttacher.mBaseRotation);
        photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
        photoViewAttacher.checkMatrixBounds();
    }

    private void setImageViewMatrix(Matrix matrix) {
        this.mImageView.setImageMatrix(matrix);
    }

    private void checkAndDisplayMatrix() {
        if (this.checkMatrixBounds()) {
            PhotoViewAttacher photoViewAttacher = this;
            photoViewAttacher.setImageViewMatrix(photoViewAttacher.getDrawMatrix());
            return;
        }
    }

    private RectF getDisplayRect(Matrix matrix) {
        Drawable drawable2 = this.mImageView.getDrawable();
        if (drawable2 != null) {
            PhotoViewAttacher photoViewAttacher = this;
            Drawable drawable3 = drawable2;
            float f = drawable3.getIntrinsicWidth();
            float f2 = drawable3.getIntrinsicHeight();
            photoViewAttacher.mDisplayRect.set(0.0f, 0.0f, f, f2);
            matrix.mapRect(photoViewAttacher.mDisplayRect);
            return this.mDisplayRect;
        }
        return null;
    }

    private void updateBaseMatrix(Drawable drawable2) {
        if (drawable2 == null) {
            return;
        }
        PhotoViewAttacher photoViewAttacher = this;
        float f = photoViewAttacher.getImageViewWidth(photoViewAttacher.mImageView);
        float f2 = photoViewAttacher.getImageViewHeight(photoViewAttacher.mImageView);
        Drawable drawable3 = drawable2;
        int n = drawable3.getIntrinsicWidth();
        int n2 = drawable3.getIntrinsicHeight();
        this.mBaseMatrix.reset();
        float f3 = n;
        float f4 = f / f3;
        float f5 = n2;
        float f6 = f2 / f5;
        ImageView.ScaleType scaleType = photoViewAttacher.mScaleType;
        if (scaleType == ImageView.ScaleType.CENTER) {
            f3 = (f - f3) / 2.0f;
            this.mBaseMatrix.postTranslate(f3, (f2 - f5) / 2.0f);
        } else if (scaleType == ImageView.ScaleType.CENTER_CROP) {
            PhotoViewAttacher photoViewAttacher2 = this;
            float f7 = f4 = Math.max(f4, f6);
            photoViewAttacher2.mBaseMatrix.postScale(f7, f7);
            f3 = (f - f3 * f4) / 2.0f;
            photoViewAttacher2.mBaseMatrix.postTranslate(f3, (f2 - f5 * f4) / 2.0f);
        } else if (scaleType == ImageView.ScaleType.CENTER_INSIDE) {
            PhotoViewAttacher photoViewAttacher3 = this;
            float f8 = f4 = Math.min(1.0f, Math.min(f4, f6));
            photoViewAttacher3.mBaseMatrix.postScale(f8, f8);
            f3 = (f - f3 * f4) / 2.0f;
            photoViewAttacher3.mBaseMatrix.postTranslate(f3, (f2 - f5 * f4) / 2.0f);
        } else {
            RectF rectF;
            RectF rectF2;
            RectF rectF3 = rectF2;
            rectF2 = new RectF(0.0f, 0.0f, f3, f5);
            RectF rectF4 = rectF;
            rectF = new RectF(0.0f, 0.0f, f, f2);
            if ((int)this.mBaseRotation % 180 != 0) {
                RectF rectF5;
                rectF3 = rectF5;
                rectF5 = new RectF(0.0f, 0.0f, f5, f3);
            }
            switch (4.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()]) {
                default: {
                    break;
                }
                case 4: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.FILL);
                    break;
                }
                case 3: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.END);
                    break;
                }
                case 2: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.START);
                    break;
                }
                case 1: {
                    this.mBaseMatrix.setRectToRect(rectF3, rectF4, Matrix.ScaleToFit.CENTER);
                }
            }
        }
        this.resetMatrix();
    }

    private boolean checkMatrixBounds() {
        float f;
        float f2;
        float f3;
        PhotoViewAttacher photoViewAttacher = this;
        RectF rectF = photoViewAttacher.getDisplayRect(photoViewAttacher.getDrawMatrix());
        if (rectF == null) {
            return false;
        }
        float f4 = rectF.height();
        PhotoViewAttacher photoViewAttacher2 = this;
        float f5 = rectF.width();
        float f6 = 0.0f;
        float f7 = 0.0f;
        float f8 = photoViewAttacher2.getImageViewHeight(photoViewAttacher2.mImageView);
        if (f3 <= f2) {
            int n = 4.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()];
            f7 = n != 2 ? (n != 3 ? (f4 = (f8 - f4) / 2.0f - rectF.top) : (f4 = f8 - f4 - rectF.top)) : (f4 = -rectF.top);
            this.mVerticalScrollEdge = 2;
        } else {
            float f9;
            f4 = rectF.top;
            if (f9 > 0.0f) {
                this.mVerticalScrollEdge = 0;
                f7 = -f4;
            } else {
                float f10;
                f4 = rectF.bottom;
                if (f10 < f8) {
                    this.mVerticalScrollEdge = 1;
                    f7 = f8 - f4;
                } else {
                    this.mVerticalScrollEdge = -1;
                }
            }
        }
        PhotoViewAttacher photoViewAttacher3 = this;
        f4 = photoViewAttacher3.getImageViewWidth(photoViewAttacher3.mImageView);
        if (f5 <= f) {
            float f11;
            float f12;
            float f13;
            int n = 4.$SwitchMap$android$widget$ImageView$ScaleType[this.mScaleType.ordinal()];
            f6 = n != 2 ? (n != 3 ? (f13 = (f4 - f5) / 2.0f - rectF.left) : (f12 = f4 - f5 - rectF.left)) : (f11 = -rectF.left);
            this.mHorizontalScrollEdge = 2;
        } else {
            float f14;
            f5 = rectF.left;
            if (f14 > 0.0f) {
                this.mHorizontalScrollEdge = 0;
                f6 = -f5;
            } else {
                float f15;
                float f16 = rectF.right;
                if (f15 < f4) {
                    f6 = f4 - f16;
                    this.mHorizontalScrollEdge = 1;
                } else {
                    this.mHorizontalScrollEdge = -1;
                }
            }
        }
        this.mSuppMatrix.postTranslate(f6, f7);
        return true;
    }

    private int getImageViewWidth(ImageView imageView) {
        return imageView.getWidth() - imageView.getPaddingLeft() - imageView.getPaddingRight();
    }

    private int getImageViewHeight(ImageView imageView) {
        return imageView.getHeight() - imageView.getPaddingTop() - imageView.getPaddingBottom();
    }

    private void cancelFling() {
        FlingRunnable flingRunnable = this.mCurrentFlingRunnable;
        if (flingRunnable != null) {
            flingRunnable.cancelFling();
            this.mCurrentFlingRunnable = null;
            return;
        }
    }

    public void setOnDoubleTapListener(GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.mGestureDetector.setOnDoubleTapListener(onDoubleTapListener);
    }

    public void setOnScaleChangeListener(OnScaleChangedListener onScaleChangedListener) {
    }

    public void setOnSingleFlingListener(OnSingleFlingListener onSingleFlingListener) {
    }

    public RectF getDisplayRect() {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.checkMatrixBounds();
        return photoViewAttacher.getDisplayRect(photoViewAttacher.getDrawMatrix());
    }

    public void setRotationTo(float f) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.setRotate(f % 360.0f);
        photoViewAttacher.checkAndDisplayMatrix();
    }

    public void setRotationBy(float f) {
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.mSuppMatrix.postRotate(f % 360.0f);
        photoViewAttacher.checkAndDisplayMatrix();
    }

    public float getMinimumScale() {
        return this.mMinScale;
    }

    public float getMediumScale() {
        return this.mMidScale;
    }

    public float getMaximumScale() {
        return this.mMaxScale;
    }

    public float getScale() {
        PhotoViewAttacher photoViewAttacher = this;
        PhotoViewAttacher photoViewAttacher2 = this;
        return (float)Math.sqrt((float)Math.pow(photoViewAttacher.getValue(photoViewAttacher.mSuppMatrix, 0), 2.0) + (float)Math.pow(photoViewAttacher2.getValue(photoViewAttacher2.mSuppMatrix, 3), 2.0));
    }

    public ImageView.ScaleType getScaleType() {
        return this.mScaleType;
    }

    public void onLayoutChange(View view, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (n == n5 && n2 == n6 && n3 == n7 && n4 == n8) {
            return;
        }
        PhotoViewAttacher photoViewAttacher = this;
        photoViewAttacher.updateBaseMatrix(photoViewAttacher.mImageView.getDrawable());
    }

    public boolean onTouch(View object, MotionEvent motionEvent) {
        boolean bl = false;
        if (this.mZoomEnabled && Util.hasDrawable((ImageView)object)) {
            int n = motionEvent.getAction();
            if (n != 0) {
                if (n == 1 || n == 3) {
                    RectF rectF;
                    if (this.getScale() < this.mMinScale) {
                        RectF rectF2 = this.getDisplayRect();
                        if (rectF2 != null) {
                            AnimatedZoomRunnable animatedZoomRunnable;
                            Object object2 = object;
                            object = animatedZoomRunnable;
                            RectF rectF3 = rectF2;
                            float f = this.getScale();
                            float f2 = this.mMinScale;
                            float f3 = rectF3.centerX();
                            float f4 = rectF3.centerY();
                            animatedZoomRunnable = new AnimatedZoomRunnable(this, f, f2, f3, f4);
                            object2.post((Runnable)object);
                            bl = true;
                        }
                    } else if (this.getScale() > this.mMaxScale && (rectF = this.getDisplayRect()) != null) {
                        AnimatedZoomRunnable animatedZoomRunnable;
                        Object object3 = object;
                        object = animatedZoomRunnable;
                        RectF rectF4 = rectF;
                        float f = this.getScale();
                        float f5 = this.mMaxScale;
                        float f6 = rectF4.centerX();
                        float f7 = rectF4.centerY();
                        animatedZoomRunnable = new AnimatedZoomRunnable(this, f, f5, f6, f7);
                        object3.post((Runnable)object);
                        bl = true;
                    }
                }
            } else {
                if ((object = object.getParent()) != null) {
                    object.requestDisallowInterceptTouchEvent(true);
                }
                this.cancelFling();
            }
            if ((object = this.mScaleDragDetector) != null) {
                boolean bl2 = this.mScaleDragDetector.isDragging();
                bl = this.mScaleDragDetector.onTouchEvent(motionEvent);
                n = !((CustomGestureDetector)object).isScaling() && !this.mScaleDragDetector.isScaling() ? 1 : 0;
                bl2 = !bl2 && !this.mScaleDragDetector.isDragging();
                bl2 = n != 0 && bl2;
                this.mBlockParentIntercept = bl2;
            }
            if ((this = this.mGestureDetector) != null && this.onTouchEvent(motionEvent)) {
                return true;
            }
            return bl;
        }
        return bl;
    }

    public void setAllowParentInterceptOnEdge(boolean bl) {
        this.mAllowParentInterceptOnEdge = bl;
    }

    public void setMinimumScale(float f) {
        PhotoViewAttacher photoViewAttacher = this;
        float f2 = photoViewAttacher.mMidScale;
        Util.checkZoomLevels(f, f2, photoViewAttacher.mMaxScale);
        this.mMinScale = f;
    }

    public void setMediumScale(float f) {
        Util.checkZoomLevels(this.mMinScale, f, this.mMaxScale);
        this.mMidScale = f;
    }

    public void setMaximumScale(float f) {
        Util.checkZoomLevels(this.mMinScale, this.mMidScale, f);
        this.mMaxScale = f;
    }

    public void setOnLongClickListener(View.OnLongClickListener onLongClickListener) {
        this.mLongClickListener = onLongClickListener;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }

    public void setOnMatrixChangeListener(OnMatrixChangedListener onMatrixChangedListener) {
    }

    public void setOnPhotoTapListener(OnPhotoTapListener onPhotoTapListener) {
    }

    public void setOnOutsidePhotoTapListener(OnOutsidePhotoTapListener onOutsidePhotoTapListener) {
    }

    public void setOnViewTapListener(OnViewTapListener onViewTapListener) {
    }

    public void setOnViewDragListener(OnViewDragListener onViewDragListener) {
    }

    public void setScale(float f) {
        this.setScale(f, false);
    }

    public void setScale(float f, boolean bl) {
        PhotoViewAttacher photoViewAttacher = this;
        float f2 = photoViewAttacher.mImageView.getRight() / 2;
        this.setScale(f, f2, photoViewAttacher.mImageView.getBottom() / 2, bl);
    }

    public void setScale(float f, float f2, float f3, boolean bl) {
        if (!(f < this.mMinScale) && !(f > this.mMaxScale)) {
            if (bl) {
                PhotoViewAttacher photoViewAttacher = this;
                this.mImageView.post((Runnable)new AnimatedZoomRunnable(photoViewAttacher, photoViewAttacher.getScale(), f, f2, f3));
                return;
            }
            PhotoViewAttacher photoViewAttacher = this;
            float f4 = f;
            photoViewAttacher.mSuppMatrix.setScale(f4, f4, f2, f3);
            photoViewAttacher.checkAndDisplayMatrix();
            return;
        }
        throw new IllegalArgumentException("Scale must be within the range of minScale and maxScale");
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (Util.isSupportedScaleType(scaleType) && scaleType != this.mScaleType) {
            this.mScaleType = scaleType;
            this.update();
            return;
        }
    }

    public void setZoomable(boolean bl) {
        this.mZoomEnabled = bl;
        this.update();
    }

    public void update() {
        if (this.mZoomEnabled) {
            PhotoViewAttacher photoViewAttacher = this;
            photoViewAttacher.updateBaseMatrix(photoViewAttacher.mImageView.getDrawable());
            return;
        }
        this.resetMatrix();
    }

    public Matrix getImageMatrix() {
        return this.mDrawMatrix;
    }

    public void setZoomTransitionDuration(int n) {
        this.mZoomDuration = n;
    }

    public class AnimatedZoomRunnable
    implements Runnable {
        private final float mFocalX;
        private final float mFocalY;
        private final long mStartTime;
        private final float mZoomStart;
        private final float mZoomEnd;
        final /* synthetic */ PhotoViewAttacher this$0;

        public AnimatedZoomRunnable(PhotoViewAttacher photoViewAttacher, float f, float f2, float f3, float f4) {
            AnimatedZoomRunnable animatedZoomRunnable = this;
            this.this$0 = photoViewAttacher;
            this.mFocalX = f3;
            animatedZoomRunnable.mFocalY = f4;
            animatedZoomRunnable.mStartTime = System.currentTimeMillis();
            this.mZoomStart = f;
            this.mZoomEnd = f2;
        }

        private float interpolate() {
            float f = Math.min(1.0f, (float)(System.currentTimeMillis() - this.mStartTime) * 1.0f / (float)this.this$0.mZoomDuration);
            return this.this$0.mInterpolator.getInterpolation(f);
        }

        @Override
        public void run() {
            float f;
            float f2 = this.interpolate();
            AnimatedZoomRunnable animatedZoomRunnable = this;
            float f3 = animatedZoomRunnable.mZoomStart;
            float f4 = f2 = (f3 + f2 * (this.mZoomEnd - f3)) / this.this$0.getScale();
            AnimatedZoomRunnable animatedZoomRunnable2 = this;
            f2 = animatedZoomRunnable2.mFocalX;
            animatedZoomRunnable.this$0.onGestureListener.onScale(f4, f2, animatedZoomRunnable2.mFocalY);
            if (f < 1.0f) {
                this.this$0.mImageView.postOnAnimation((Runnable)this);
                return;
            }
        }
    }

    public class FlingRunnable
    implements Runnable {
        private final OverScroller mScroller;
        private int mCurrentX;
        private int mCurrentY;

        public FlingRunnable(Context context) {
            OverScroller overScroller;
            FlingRunnable flingRunnable = overScroller;
            overScroller = new OverScroller(context);
            v1.mScroller = flingRunnable;
        }

        public void cancelFling() {
            this.mScroller.forceFinished(true);
        }

        public void fling(int n, int n2, int n3, int n4) {
            int n5;
            int n6;
            int n7;
            int n8;
            block8: {
                block7: {
                    float f;
                    float f2;
                    RectF rectF = PhotoViewAttacher.this.getDisplayRect();
                    if (rectF == null) break block7;
                    int n9 = n;
                    n = Math.round(-rectF.left);
                    float f3 = n9;
                    if (f2 < rectF.width()) {
                        n8 = 0;
                        n7 = Math.round(rectF.width() - f3);
                    } else {
                        n8 = n;
                        n7 = n;
                    }
                    int n10 = n2;
                    n2 = Math.round(-rectF.top);
                    float f4 = n10;
                    if (f < rectF.height()) {
                        n6 = 0;
                        n5 = Math.round(rectF.height() - f4);
                    } else {
                        n6 = n2;
                        n5 = n2;
                    }
                    FlingRunnable flingRunnable = this;
                    flingRunnable.mCurrentX = n;
                    flingRunnable.mCurrentY = n2;
                    if (n != n7 || n2 != n5) break block8;
                }
                return;
            }
            this.mScroller.fling(n, n2, n3, n4, n8, n7, n6, n5, 0, 0);
        }

        @Override
        public void run() {
            if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
                FlingRunnable flingRunnable = this;
                int n = flingRunnable.mScroller.getCurrX();
                FlingRunnable flingRunnable2 = this;
                int n2 = flingRunnable2.mScroller.getCurrY();
                flingRunnable2.PhotoViewAttacher.this.mSuppMatrix.postTranslate((float)(this.mCurrentX - n), (float)(this.mCurrentY - n2));
                flingRunnable2.PhotoViewAttacher.this.checkAndDisplayMatrix();
                flingRunnable.mCurrentX = n;
                flingRunnable.mCurrentY = n2;
                flingRunnable.PhotoViewAttacher.this.mImageView.postOnAnimation((Runnable)this);
                return;
            }
        }
    }
}

