/*
 * Decompiled with CFR 0.152.
 */
package io.boxo.ui.qrscanner;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.Image;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.android.gms.tasks.Task;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import io.boxo.R;
import io.boxo.utils.Permissions;
import io.boxo.utils.extensions.ActivityKt;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 :2\u00020\u0001:\u0002:;B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0014J\u0012\u0010%\u001a\u00020\"2\b\u0010&\u001a\u0004\u0018\u00010'H\u0014J\b\u0010(\u001a\u00020\"H\u0002J\b\u0010)\u001a\u00020\"H\u0002J\b\u0010*\u001a\u00020\"H\u0002J\b\u0010+\u001a\u00020\"H\u0014J+\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020.2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002000/2\u0006\u00101\u001a\u000202H\u0016\u00a2\u0006\u0002\u00103J\"\u00104\u001a\u00020\"2\u0006\u0010-\u001a\u00020.2\u0006\u00105\u001a\u00020.2\b\u00106\u001a\u0004\u0018\u000107H\u0014J\u0010\u00108\u001a\u00020\"2\u0006\u00109\u001a\u000200H\u0002R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\t\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\t\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0014\u001a\u00020\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\t\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lio/boxo/ui/qrscanner/QRScannerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "<init>", "()V", "previewView", "Landroidx/camera/view/PreviewView;", "getPreviewView", "()Landroidx/camera/view/PreviewView;", "previewView$delegate", "Lkotlin/Lazy;", "flashIcon", "Landroid/widget/ImageView;", "getFlashIcon", "()Landroid/widget/ImageView;", "flashIcon$delegate", "flashText", "Landroid/widget/TextView;", "getFlashText", "()Landroid/widget/TextView;", "flashText$delegate", "permissions", "Lio/boxo/utils/Permissions;", "getPermissions", "()Lio/boxo/utils/Permissions;", "permissions$delegate", "cameraExecutor", "Ljava/util/concurrent/ExecutorService;", "camera", "Landroidx/camera/core/Camera;", "imageAnalyzer", "Landroidx/camera/core/ImageAnalysis;", "flashEnabled", "", "attachBaseContext", "", "newBase", "Landroid/content/Context;", "onCreate", "state", "Landroid/os/Bundle;", "requestCameraPermission", "init", "startCamera", "onDestroy", "onRequestPermissionsResult", "requestCode", "", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "onActivityResult", "resultCode", "data", "Landroid/content/Intent;", "handleQRCode", "rawResult", "Companion", "QRCodeAnalyzer", "boxo_release"})
public final class QRScannerActivity
extends AppCompatActivity {
    public static final Companion Companion = new Companion(null);
    private final Lazy previewView$delegate;
    private final Lazy flashIcon$delegate;
    private final Lazy flashText$delegate;
    private final Lazy permissions$delegate;
    private ExecutorService cameraExecutor;
    private Camera camera;
    private ImageAnalysis imageAnalyzer;
    private boolean flashEnabled;

    public QRScannerActivity() {
        QRScannerActivity qRScannerActivity = this;
        qRScannerActivity.previewView$delegate = ActivityKt.bindView((Activity)qRScannerActivity, R.id.preview_view);
        qRScannerActivity.flashIcon$delegate = ActivityKt.bindView((Activity)qRScannerActivity, R.id.flash_icon);
        qRScannerActivity.flashText$delegate = ActivityKt.bindView((Activity)qRScannerActivity, R.id.flash_text);
        qRScannerActivity.permissions$delegate = LazyKt.lazy(() -> QRScannerActivity.permissions_delegate$lambda$0(qRScannerActivity));
    }

    private final PreviewView getPreviewView() {
        return (PreviewView)this.previewView$delegate.getValue();
    }

    private final ImageView getFlashIcon() {
        return (ImageView)this.flashIcon$delegate.getValue();
    }

    private final TextView getFlashText() {
        return (TextView)this.flashText$delegate.getValue();
    }

    private final Permissions getPermissions() {
        return (Permissions)this.permissions$delegate.getValue();
    }

    private final void requestCameraPermission() {
        Permissions permissions = qRScannerActivity2.getPermissions();
        QRScannerActivity qRScannerActivity = qRScannerActivity2;
        QRScannerActivity qRScannerActivity2 = () -> QRScannerActivity.requestCameraPermission$lambda$2(qRScannerActivity);
        Function0 function0 = () -> QRScannerActivity.requestCameraPermission$lambda$3(qRScannerActivity);
        Function0 function02 = () -> QRScannerActivity.requestCameraPermission$lambda$6(qRScannerActivity);
        permissions.camera((Activity)qRScannerActivity, (Function0<Unit>)qRScannerActivity2, (Function0<Unit>)function0, (Function0<Unit>)function02);
    }

    private final void init() {
        this.cameraExecutor = Executors.newSingleThreadExecutor();
        this.getFlashIcon().setOnClickListener(arg_0 -> QRScannerActivity.init$lambda$8(this, arg_0));
    }

    private final void startCamera() {
        ListenableFuture listenableFuture = ProcessCameraProvider.Companion.getInstance((Context)object);
        Object object = () -> QRScannerActivity.startCamera$lambda$12(listenableFuture, (QRScannerActivity)((Object)object));
        listenableFuture.addListener((Runnable)object, ContextCompat.getMainExecutor((Context)object));
    }

    private final void handleQRCode(String string2) {
        QRScannerActivity qRScannerActivity = this;
        qRScannerActivity.setResult(-1, qRScannerActivity.getIntent().putExtra("qr_result", string2));
        qRScannerActivity.finish();
    }

    private static final Permissions permissions_delegate$lambda$0(QRScannerActivity qRScannerActivity) {
        return new Permissions((Activity)qRScannerActivity);
    }

    private static final void requestCameraPermission$lambda$2$lambda$1(QRScannerActivity qRScannerActivity) {
        qRScannerActivity.startCamera();
    }

    private static final Unit requestCameraPermission$lambda$2(QRScannerActivity qRScannerActivity) {
        qRScannerActivity.getPreviewView().post(() -> QRScannerActivity.requestCameraPermission$lambda$2$lambda$1(qRScannerActivity));
        return Unit.INSTANCE;
    }

    private static final Unit requestCameraPermission$lambda$3(QRScannerActivity qRScannerActivity) {
        qRScannerActivity.finish();
        return Unit.INSTANCE;
    }

    private static final Unit requestCameraPermission$lambda$6$lambda$4(QRScannerActivity qRScannerActivity) {
        qRScannerActivity.finish();
        return Unit.INSTANCE;
    }

    private static final Unit requestCameraPermission$lambda$6$lambda$5(QRScannerActivity qRScannerActivity) {
        ActivityKt.openSettings((Activity)qRScannerActivity, 1001);
        return Unit.INSTANCE;
    }

    private static final Unit requestCameraPermission$lambda$6(QRScannerActivity object) {
        QRScannerActivity qRScannerActivity = object;
        object = qRScannerActivity.getString(R.string.boxo_camera_permission_denied_text);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getString(...)");
        String string2 = qRScannerActivity.getString(R.string.boxo_open_settings_btn);
        Function0 function0 = () -> QRScannerActivity.requestCameraPermission$lambda$6$lambda$4(qRScannerActivity);
        Function0 function02 = () -> QRScannerActivity.requestCameraPermission$lambda$6$lambda$5(qRScannerActivity);
        ActivityKt.showDialog$default((Activity)qRScannerActivity, null, (String)object, null, string2, function0, function02, 5, null);
        return Unit.INSTANCE;
    }

    private static final void init$lambda$8$lambda$7(QRScannerActivity qRScannerActivity) {
        boolean bl = qRScannerActivity.flashEnabled;
        qRScannerActivity.flashEnabled = bl ^ true;
        if (!bl) {
            QRScannerActivity qRScannerActivity2 = qRScannerActivity;
            qRScannerActivity2.getFlashIcon().setImageResource(R.drawable.boxo_flash_on);
            qRScannerActivity2.getFlashText().setText(R.string.boxo_flash_on);
            return;
        }
        QRScannerActivity qRScannerActivity3 = qRScannerActivity;
        qRScannerActivity3.getFlashIcon().setImageResource(R.drawable.boxo_flash_off);
        qRScannerActivity3.getFlashText().setText(R.string.boxo_flash_off);
    }

    private static final void init$lambda$8(QRScannerActivity object, View view) {
        view = object.camera;
        if (view != null && (view = view.getCameraControl()) != null && (view = view.enableTorch(object.flashEnabled ^ true)) != null) {
            QRScannerActivity qRScannerActivity = object;
            object = () -> QRScannerActivity.init$lambda$8$lambda$7(qRScannerActivity);
            view.addListener((Runnable)object, ContextCompat.getMainExecutor((Context)qRScannerActivity));
            return;
        }
    }

    private static final Unit startCamera$lambda$12$lambda$11$lambda$10(QRScannerActivity qRScannerActivity, String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter((Object)string3, (String)"qrCode");
        qRScannerActivity.handleQRCode(string3);
        return Unit.INSTANCE;
    }

    private static final void startCamera$lambda$12(ListenableFuture object, QRScannerActivity qRScannerActivity) {
        QRCodeAnalyzer qRCodeAnalyzer;
        Object v = object.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        object = (ProcessCameraProvider)v;
        Preview preview = new Preview.Builder().build();
        preview.setSurfaceProvider(qRScannerActivity.getPreviewView().getSurfaceProvider());
        Intrinsics.checkNotNullExpressionValue((Object)preview, (String)"also(...)");
        UseCase[] useCaseArray = new ImageAnalysis.Builder().setBackpressureStrategy(0).build();
        ExecutorService executorService = qRScannerActivity.cameraExecutor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraExecutor");
            executorService = null;
        }
        QRScannerActivity qRScannerActivity2 = qRScannerActivity;
        ListenableFuture listenableFuture = object;
        QRScannerActivity qRScannerActivity3 = qRScannerActivity;
        ListenableFuture listenableFuture2 = object;
        object = qRCodeAnalyzer;
        qRCodeAnalyzer = new QRCodeAnalyzer((Function1<? super String, Unit>)((Function1)arg_0 -> QRScannerActivity.startCamera$lambda$12$lambda$11$lambda$10(qRScannerActivity, arg_0)));
        useCaseArray.setAnalyzer((Executor)executorService, (ImageAnalysis.Analyzer)object);
        qRScannerActivity.imageAnalyzer = useCaseArray;
        try {
            listenableFuture2.unbindAll();
            object = CameraSelector.DEFAULT_BACK_CAMERA;
        }
        catch (Exception exception) {
            Log.e((String)"BoxoSDK", (String)"Use case binding failed", (Throwable)exception);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DEFAULT_BACK_CAMERA");
        qRScannerActivity = qRScannerActivity3.imageAnalyzer;
        UseCase[] useCaseArray2 = new UseCase[2];
        useCaseArray = useCaseArray2;
        useCaseArray2[0] = preview;
        useCaseArray2[1] = qRScannerActivity;
        qRScannerActivity2.camera = listenableFuture.bindToLifecycle((LifecycleOwner)qRScannerActivity3, (CameraSelector)object, useCaseArray);
    }

    public void attachBaseContext(Context context) {
        QRScannerActivity qRScannerActivity = this;
        ActivityKt.setMiniappLocale((Activity)qRScannerActivity);
        super.attachBaseContext(context);
    }

    public void onCreate(Bundle bundle) {
        QRScannerActivity qRScannerActivity = this;
        super.onCreate(bundle);
        qRScannerActivity.setContentView(R.layout.boxo_activity_qr_scanner);
        ActivityKt.fullscreen((Activity)qRScannerActivity);
        qRScannerActivity.init();
        qRScannerActivity.requestCameraPermission();
    }

    public void onDestroy() {
        ExecutorService executorService = this.cameraExecutor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraExecutor");
            executorService = null;
        }
        executorService.shutdown();
        super.onDestroy();
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"grantResults");
        this.getPermissions().onRequestPermissionsResult((Activity)this, n, stringArray, nArray);
        super.onRequestPermissionsResult(n, stringArray, nArray);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (n == 1001) {
            this.requestCameraPermission();
            return;
        }
        super.onActivityResult(n, n2, intent);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/boxo/ui/qrscanner/QRScannerActivity$Companion;", "", "<init>", "()V", "SETTINGS_REQUEST_CODE", "", "QR_RESULT", "", "boxo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0017R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/boxo/ui/qrscanner/QRScannerActivity$QRCodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "onQRCodeFound", "Lkotlin/Function1;", "", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "scanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "analyze", "imageProxy", "Landroidx/camera/core/ImageProxy;", "boxo_release"})
    public static final class QRCodeAnalyzer
    implements ImageAnalysis.Analyzer {
        private final Function1<String, Unit> onQRCodeFound;
        private final BarcodeScanner scanner;

        public QRCodeAnalyzer(Function1<? super String, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"onQRCodeFound");
            qRCodeAnalyzer.onQRCodeFound = function1;
            QRCodeAnalyzer qRCodeAnalyzer = BarcodeScanning.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)qRCodeAnalyzer, (String)"getClient(...)");
            v0.scanner = qRCodeAnalyzer;
        }

        private static final Unit analyze$lambda$1(QRCodeAnalyzer qRCodeAnalyzer, List object) {
            List list = object;
            Intrinsics.checkNotNull((Object)list);
            object = (Barcode)CollectionsKt.firstOrNull((List)list);
            if (object != null && (object = object.getRawValue()) != null) {
                qRCodeAnalyzer.onQRCodeFound.invoke(object);
            }
            return Unit.INSTANCE;
        }

        private static final void analyze$lambda$2(Function1 function1, Object object) {
            function1.invoke(object);
        }

        private static final void analyze$lambda$3(ImageProxy imageProxy, Task task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"it");
            imageProxy.close();
        }

        public void analyze(ImageProxy imageProxy) {
            ImageProxy imageProxy2 = imageProxy;
            Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"imageProxy");
            Image image = imageProxy2.getImage();
            if (image != null) {
                image = InputImage.fromMediaImage((Image)image, (int)imageProxy.getImageInfo().getRotationDegrees());
                Intrinsics.checkNotNullExpressionValue((Object)image, (String)"fromMediaImage(...)");
                Intrinsics.checkNotNull((Object)this.scanner.process((InputImage)image).addOnSuccessListener(arg_0 -> QRCodeAnalyzer.analyze$lambda$2(arg_0 -> QRCodeAnalyzer.analyze$lambda$1(this, arg_0), arg_0)).addOnCompleteListener(arg_0 -> QRCodeAnalyzer.analyze$lambda$3(imageProxy, arg_0)));
                return;
            }
            imageProxy.close();
        }
    }
}

