/*
 * Decompiled with CFR 0.152.
 */
package io.boxo.ui.qrscanner;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.Image;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.android.gms.tasks.Task;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import io.boxo.R;
import io.boxo.ui.qrscanner.QRScannerActivity;
import io.boxo.utils.Permissions;
import io.boxo.utils.extensions.ActivityKt;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\u0018\u0000 92\u00020\u0001:\u00029:B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0002J\b\u0010'\u001a\u00020!H\u0002J\"\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*2\b\u0010,\u001a\u0004\u0018\u00010-H\u0014J\u0012\u0010.\u001a\u00020!2\b\u0010/\u001a\u0004\u0018\u000100H\u0014J\b\u00101\u001a\u00020!H\u0014J+\u00102\u001a\u00020!2\u0006\u0010)\u001a\u00020*2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020&032\u0006\u00104\u001a\u000205H\u0016\u00a2\u0006\u0002\u00106J\b\u00107\u001a\u00020!H\u0002J\b\u00108\u001a\u00020!H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u000e\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0016\u001a\u00020\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010\u000e\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006;"}, d2={"Lio/boxo/ui/qrscanner/QRScannerActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "camera", "Landroidx/camera/core/Camera;", "cameraExecutor", "Ljava/util/concurrent/ExecutorService;", "flashEnabled", "", "flashIcon", "Landroid/widget/ImageView;", "getFlashIcon", "()Landroid/widget/ImageView;", "flashIcon$delegate", "Lkotlin/Lazy;", "flashText", "Landroid/widget/TextView;", "getFlashText", "()Landroid/widget/TextView;", "flashText$delegate", "imageAnalyzer", "Landroidx/camera/core/ImageAnalysis;", "permissions", "Lio/boxo/utils/Permissions;", "getPermissions", "()Lio/boxo/utils/Permissions;", "permissions$delegate", "previewView", "Landroidx/camera/view/PreviewView;", "getPreviewView", "()Landroidx/camera/view/PreviewView;", "previewView$delegate", "attachBaseContext", "", "newBase", "Landroid/content/Context;", "handleQRCode", "rawResult", "", "init", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "state", "Landroid/os/Bundle;", "onDestroy", "onRequestPermissionsResult", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "requestCameraPermission", "startCamera", "Companion", "QRCodeAnalyzer", "boxo_release"})
public final class QRScannerActivity
extends AppCompatActivity {
    public static final Companion Companion = new Companion(null);
    private final Lazy previewView$delegate;
    private final Lazy flashIcon$delegate;
    private final Lazy flashText$delegate;
    private final Lazy permissions$delegate;
    private ExecutorService cameraExecutor;
    private Camera camera;
    private ImageAnalysis imageAnalyzer;
    private boolean flashEnabled;

    public QRScannerActivity() {
        QRScannerActivity qRScannerActivity = this;
        qRScannerActivity.previewView$delegate = ActivityKt.bindView((Activity)qRScannerActivity, R.id.preview_view);
        qRScannerActivity.flashIcon$delegate = ActivityKt.bindView((Activity)qRScannerActivity, R.id.flash_icon);
        qRScannerActivity.flashText$delegate = ActivityKt.bindView((Activity)qRScannerActivity, R.id.flash_text);
        qRScannerActivity.permissions$delegate = LazyKt.lazy((Function0)new Function0<Permissions>(this){
            final /* synthetic */ QRScannerActivity this$0;
            {
                this.this$0 = qRScannerActivity;
                super(0);
            }

            public final Permissions invoke() {
                return new Permissions((Activity)this.this$0);
            }
        });
    }

    private final PreviewView getPreviewView() {
        return (PreviewView)this.previewView$delegate.getValue();
    }

    private final ImageView getFlashIcon() {
        return (ImageView)this.flashIcon$delegate.getValue();
    }

    private final TextView getFlashText() {
        return (TextView)this.flashText$delegate.getValue();
    }

    private final Permissions getPermissions() {
        return (Permissions)this.permissions$delegate.getValue();
    }

    private final void requestCameraPermission() {
        Function0<Unit> function0;
        Function0<Unit> function02;
        Function0<Unit> function03;
        Function0<Unit> function04 = function03;
        function03 = new Function0<Unit>(this){
            final /* synthetic */ QRScannerActivity this$0;
            {
                this.this$0 = qRScannerActivity;
                super(0);
            }

            private static final void invoke$lambda$0(QRScannerActivity qRScannerActivity) {
                QRScannerActivity qRScannerActivity2 = qRScannerActivity;
                Intrinsics.checkNotNullParameter((Object)((Object)qRScannerActivity2), (String)"this$0");
                QRScannerActivity.access$startCamera(qRScannerActivity2);
            }

            public final void invoke() {
                QRScannerActivity.access$getPreviewView(this.this$0).post(() -> requestCameraPermission.1.invoke$lambda$0(this.this$0));
            }
        };
        Function0<Unit> function05 = function02;
        function02 = new Function0<Unit>(this){
            final /* synthetic */ QRScannerActivity this$0;
            {
                this.this$0 = qRScannerActivity;
                super(0);
            }

            public final void invoke() {
                this.this$0.finish();
            }
        };
        Function0<Unit> function06 = function0;
        function0 = new Function0<Unit>(this){
            final /* synthetic */ QRScannerActivity this$0;
            {
                this.this$0 = qRScannerActivity;
                super(0);
            }

            public final void invoke() {
                Function0<Unit> function0;
                Function0<Unit> function02;
                QRScannerActivity qRScannerActivity = this.this$0;
                String string2 = qRScannerActivity.getString(R.string.boxo_camera_permission_denied_text);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                String string3 = this.this$0.getString(R.string.boxo_open_settings_btn);
                Function0<Unit> function03 = function02;
                function02 = new Function0<Unit>(this.this$0){
                    final /* synthetic */ QRScannerActivity this$0;
                    {
                        this.this$0 = qRScannerActivity;
                        super(0);
                    }

                    public final void invoke() {
                        this.this$0.finish();
                    }
                };
                Function0<Unit> function04 = function0;
                function0 = new Function0<Unit>(this.this$0){
                    final /* synthetic */ QRScannerActivity this$0;
                    {
                        this.this$0 = qRScannerActivity;
                        super(0);
                    }

                    public final void invoke() {
                        ActivityKt.openSettings((Activity)this.this$0, 1001);
                    }
                };
                ActivityKt.showDialog$default((Activity)qRScannerActivity, null, string2, null, string3, (Function0)function03, (Function0)function04, 5, null);
            }
        };
        this.getPermissions().camera((Activity)this, function04, function05, function06);
    }

    private final void init() {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.cameraExecutor = executorService;
        this.getFlashIcon().setOnClickListener(arg_0 -> QRScannerActivity.init$lambda$1(this, arg_0));
    }

    private final void startCamera() {
        ListenableFuture listenableFuture = ProcessCameraProvider.Companion.getInstance((Context)object);
        Object object = () -> QRScannerActivity.startCamera$lambda$4(listenableFuture, (QRScannerActivity)((Object)object));
        listenableFuture.addListener((Runnable)object, ContextCompat.getMainExecutor((Context)object));
    }

    private final void handleQRCode(String string2) {
        QRScannerActivity qRScannerActivity = this;
        qRScannerActivity.setResult(-1, qRScannerActivity.getIntent().putExtra("qr_result", string2));
        qRScannerActivity.finish();
    }

    private static final void init$lambda$1$lambda$0(QRScannerActivity qRScannerActivity) {
        QRScannerActivity qRScannerActivity2 = qRScannerActivity;
        Intrinsics.checkNotNullParameter((Object)((Object)qRScannerActivity2), (String)"this$0");
        boolean bl = qRScannerActivity2.flashEnabled;
        qRScannerActivity.flashEnabled = bl ^ true;
        if (!bl) {
            QRScannerActivity qRScannerActivity3 = qRScannerActivity;
            qRScannerActivity3.getFlashIcon().setImageResource(R.drawable.boxo_flash_on);
            qRScannerActivity3.getFlashText().setText(R.string.boxo_flash_on);
            return;
        }
        QRScannerActivity qRScannerActivity4 = qRScannerActivity;
        qRScannerActivity4.getFlashIcon().setImageResource(R.drawable.boxo_flash_off);
        qRScannerActivity4.getFlashText().setText(R.string.boxo_flash_off);
    }

    private static final void init$lambda$1(QRScannerActivity object, View view) {
        QRScannerActivity qRScannerActivity = object;
        Intrinsics.checkNotNullParameter((Object)((Object)qRScannerActivity), (String)"this$0");
        view = qRScannerActivity.camera;
        if (view != null && (view = view.getCameraControl()) != null && (view = view.enableTorch(object.flashEnabled ^ true)) != null) {
            QRScannerActivity qRScannerActivity2 = object;
            object = () -> QRScannerActivity.init$lambda$1$lambda$0(qRScannerActivity2);
            view.addListener((Runnable)object, ContextCompat.getMainExecutor((Context)qRScannerActivity2));
            return;
        }
    }

    private static final void startCamera$lambda$4(ListenableFuture object, QRScannerActivity qRScannerActivity) {
        QRCodeAnalyzer qRCodeAnalyzer;
        Intrinsics.checkNotNullParameter((Object)object, (String)"$cameraProviderFuture");
        Intrinsics.checkNotNullParameter((Object)((Object)qRScannerActivity), (String)"this$0");
        Object v = object.get();
        Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
        object = (ProcessCameraProvider)v;
        Preview preview = new Preview.Builder().build();
        preview.setSurfaceProvider(qRScannerActivity.getPreviewView().getSurfaceProvider());
        Intrinsics.checkNotNullExpressionValue((Object)preview, (String)"also(...)");
        UseCase[] useCaseArray = new ImageAnalysis.Builder().setBackpressureStrategy(0).build();
        ExecutorService executorService = qRScannerActivity.cameraExecutor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraExecutor");
            executorService = null;
        }
        QRScannerActivity qRScannerActivity2 = qRScannerActivity;
        ListenableFuture listenableFuture = object;
        QRScannerActivity qRScannerActivity3 = qRScannerActivity;
        ListenableFuture listenableFuture2 = object;
        object = qRCodeAnalyzer;
        qRCodeAnalyzer = new QRCodeAnalyzer((Function1<? super String, Unit>)new Function1<String, Unit>(qRScannerActivity){
            final /* synthetic */ QRScannerActivity this$0;
            {
                this.this$0 = qRScannerActivity;
                super(1);
            }

            public final void invoke(String string2) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"qrCode");
                QRScannerActivity.access$handleQRCode(this.this$0, string2);
            }
        });
        useCaseArray.setAnalyzer((Executor)executorService, (ImageAnalysis.Analyzer)object);
        qRScannerActivity.imageAnalyzer = useCaseArray;
        try {
            listenableFuture2.unbindAll();
            object = CameraSelector.DEFAULT_BACK_CAMERA;
        }
        catch (Exception exception) {
            Log.e((String)"BoxoSDK", (String)"Use case binding failed", (Throwable)exception);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DEFAULT_BACK_CAMERA");
        qRScannerActivity = qRScannerActivity3.imageAnalyzer;
        UseCase[] useCaseArray2 = new UseCase[2];
        useCaseArray = useCaseArray2;
        useCaseArray2[0] = preview;
        useCaseArray2[1] = qRScannerActivity;
        qRScannerActivity2.camera = listenableFuture.bindToLifecycle((LifecycleOwner)qRScannerActivity3, (CameraSelector)object, useCaseArray);
    }

    public static final /* synthetic */ PreviewView access$getPreviewView(QRScannerActivity qRScannerActivity) {
        return qRScannerActivity.getPreviewView();
    }

    public static final /* synthetic */ void access$startCamera(QRScannerActivity qRScannerActivity) {
        qRScannerActivity.startCamera();
    }

    public static final /* synthetic */ void access$handleQRCode(QRScannerActivity qRScannerActivity, String string2) {
        qRScannerActivity.handleQRCode(string2);
    }

    public void attachBaseContext(Context context) {
        QRScannerActivity qRScannerActivity = this;
        ActivityKt.setMiniappLocale((Activity)qRScannerActivity);
        super.attachBaseContext(context);
    }

    public void onCreate(Bundle bundle) {
        QRScannerActivity qRScannerActivity = this;
        super.onCreate(bundle);
        qRScannerActivity.setContentView(R.layout.boxo_activity_qr_scanner);
        ActivityKt.edgeToEdge((Activity)qRScannerActivity);
        qRScannerActivity.init();
        qRScannerActivity.requestCameraPermission();
    }

    public void onDestroy() {
        ExecutorService executorService = this.cameraExecutor;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cameraExecutor");
            executorService = null;
        }
        executorService.shutdown();
        super.onDestroy();
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)stringArray, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"grantResults");
        this.getPermissions().onRequestPermissionsResult((Activity)this, n, stringArray, nArray);
        super.onRequestPermissionsResult(n, stringArray, nArray);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        if (n == 1001) {
            this.requestCameraPermission();
            return;
        }
        super.onActivityResult(n, n2, intent);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/boxo/ui/qrscanner/QRScannerActivity$Companion;", "", "()V", "QR_RESULT", "", "SETTINGS_REQUEST_CODE", "", "boxo_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0017R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/boxo/ui/qrscanner/QRScannerActivity$QRCodeAnalyzer;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "onQRCodeFound", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "scanner", "Lcom/google/mlkit/vision/barcode/BarcodeScanner;", "analyze", "imageProxy", "Landroidx/camera/core/ImageProxy;", "boxo_release"})
    public static final class QRCodeAnalyzer
    implements ImageAnalysis.Analyzer {
        private final Function1<String, Unit> onQRCodeFound;
        private final BarcodeScanner scanner;

        public QRCodeAnalyzer(Function1<? super String, Unit> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"onQRCodeFound");
            qRCodeAnalyzer.onQRCodeFound = function1;
            QRCodeAnalyzer qRCodeAnalyzer = BarcodeScanning.getClient();
            Intrinsics.checkNotNullExpressionValue((Object)qRCodeAnalyzer, (String)"getClient(...)");
            v0.scanner = qRCodeAnalyzer;
        }

        private static final void analyze$lambda$0(Function1 function1, Object object) {
            Function1 function12 = function1;
            Intrinsics.checkNotNullParameter((Object)function12, (String)"$tmp0");
            function12.invoke(object);
        }

        private static final void analyze$lambda$1(ImageProxy imageProxy, Task task) {
            Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"$imageProxy");
            Intrinsics.checkNotNullParameter((Object)task, (String)"it");
            imageProxy.close();
        }

        public static final /* synthetic */ Function1 access$getOnQRCodeFound$p(QRCodeAnalyzer qRCodeAnalyzer) {
            return qRCodeAnalyzer.onQRCodeFound;
        }

        public void analyze(ImageProxy imageProxy) {
            ImageProxy imageProxy2 = imageProxy;
            Intrinsics.checkNotNullParameter((Object)imageProxy2, (String)"imageProxy");
            Image image = imageProxy2.getImage();
            if (image != null) {
                image = InputImage.fromMediaImage((Image)image, (int)imageProxy.getImageInfo().getRotationDegrees());
                Intrinsics.checkNotNullExpressionValue((Object)image, (String)"fromMediaImage(...)");
                this.scanner.process((InputImage)image).addOnSuccessListener(arg_0 -> QRCodeAnalyzer.analyze$lambda$0((Function1)new Function1<List<Barcode>, Unit>(this){
                    final /* synthetic */ QRCodeAnalyzer this$0;
                    {
                        this.this$0 = qRCodeAnalyzer;
                        super(1);
                    }

                    public final void invoke(List<Barcode> object) {
                        Barcode barcode = object;
                        Intrinsics.checkNotNull(barcode);
                        object = (Barcode)CollectionsKt.firstOrNull(barcode);
                        if (object != null && (object = object.getRawValue()) != null) {
                            QRCodeAnalyzer.access$getOnQRCodeFound$p(this.this$0).invoke(object);
                            return;
                        }
                    }
                }, arg_0)).addOnCompleteListener(arg_0 -> QRCodeAnalyzer.analyze$lambda$1(imageProxy, arg_0));
                return;
            }
            imageProxy.close();
        }
    }
}

