/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.docker.compose.plugin;

import io.brachu.docker.compose.plugin.Config;
import io.brachu.docker.compose.plugin.ConfigValidator;
import io.brachu.docker.compose.plugin.DockerComposeFactory;
import io.brachu.docker.compose.plugin.WaitConfig;
import io.brachu.johann.DockerCompose;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractDockerComposeMojo
extends AbstractMojo {
    private static final String PROJECT_NAME_PROPERTY = "maven.dockerCompose.project";
    private static final String FAILSAFE_ARGLINE_PROPERTY = "argLine";
    @Parameter(required=true, readonly=true, defaultValue="${project}")
    protected MavenProject project;
    @Parameter(required=true, readonly=true, defaultValue="${project.basedir}")
    private File basedir;
    @Parameter(property="dockerCompose.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private String executablePath;
    @Parameter(defaultValue="${project.basedir}")
    private File workDir;
    @Parameter(required=true, defaultValue="src/test/resources/docker-compose.yml")
    private String file;
    @Parameter(defaultValue="${maven.dockerCompose.project}")
    private String projectName;
    @Parameter
    private Map<String, String> env;
    @Parameter
    private WaitConfig wait;
    private DockerComposeFactory dockerComposeFactory = new DockerComposeFactory();

    AbstractDockerComposeMojo() {
    }

    DockerCompose dockerCompose(Config config) throws MojoFailureException {
        try {
            return this.dockerComposeFactory.create(config);
        }
        catch (Exception ex) {
            throw new MojoFailureException("Cannot build DockerCompose object", (Throwable)ex);
        }
    }

    Config getConfig() throws MojoFailureException {
        Config config = new Config(this.executablePath, this.workDir, this.basedir, this.file, this.projectName, this.env, this.wait, this.skip);
        ConfigValidator.validate(config);
        return config;
    }

    void fillProperties(DockerCompose compose) {
        this.fillProjectProperties(compose);
        this.fillFailsafeArgLine(compose);
        this.fillSystemProperties(compose);
    }

    void clearProperties(DockerCompose compose) {
        this.clearProjectProperties();
        this.clearFailsafeArgLine(compose);
        this.clearSystemProperties();
    }

    private void fillProjectProperties(DockerCompose compose) {
        this.project.getProperties().setProperty(PROJECT_NAME_PROPERTY, compose.getProjectName());
    }

    private void clearProjectProperties() {
        this.project.getProperties().remove(PROJECT_NAME_PROPERTY);
    }

    private void fillFailsafeArgLine(DockerCompose compose) {
        Object failsafeArgLine = this.project.getProperties().getProperty(FAILSAFE_ARGLINE_PROPERTY);
        String argLineParam = this.constructFailsafeArgLine(compose);
        failsafeArgLine = failsafeArgLine != null && !((String)failsafeArgLine).contains(argLineParam) ? argLineParam + " " + (String)failsafeArgLine : argLineParam;
        this.project.getProperties().setProperty(FAILSAFE_ARGLINE_PROPERTY, (String)failsafeArgLine);
    }

    private void clearFailsafeArgLine(DockerCompose compose) {
        String failsafeArgLine = this.project.getProperties().getProperty(FAILSAFE_ARGLINE_PROPERTY);
        if (failsafeArgLine != null) {
            if ((failsafeArgLine = StringUtils.trimToNull((String)failsafeArgLine.replace(this.constructFailsafeArgLine(compose), ""))) != null) {
                this.project.getProperties().setProperty(FAILSAFE_ARGLINE_PROPERTY, failsafeArgLine);
            } else {
                this.project.getProperties().remove(FAILSAFE_ARGLINE_PROPERTY);
            }
        }
    }

    private String constructFailsafeArgLine(DockerCompose compose) {
        return "-Dmaven.dockerCompose.project=" + compose.getProjectName();
    }

    private void fillSystemProperties(DockerCompose compose) {
        System.setProperty(PROJECT_NAME_PROPERTY, compose.getProjectName());
    }

    private void clearSystemProperties() {
        System.clearProperty(PROJECT_NAME_PROPERTY);
    }
}

