/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.docker.compose.plugin;

import io.brachu.docker.compose.plugin.AbstractDockerComposeMojo;
import io.brachu.docker.compose.plugin.Config;
import io.brachu.johann.DockerCompose;
import io.brachu.johann.DownConfig;
import io.brachu.johann.exception.JohannException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="down", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public final class DownMojo
extends AbstractDockerComposeMojo {
    @Parameter(required=true, defaultValue="true")
    private boolean removeVolumes;
    @Parameter(required=true, defaultValue="false")
    private boolean removeOrphans;
    @Parameter(required=true, defaultValue="10")
    private int downTimeoutSeconds;
    @Parameter(required=true, defaultValue="true")
    private boolean killBeforeDown;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Config config = this.getConfig();
        if (config.shouldExecute()) {
            DockerCompose compose = this.dockerCompose(config);
            this.clearProperties(compose);
            this.down(compose);
        } else {
            this.getLog().info((CharSequence)"Skipping.");
        }
    }

    private void down(DockerCompose compose) throws MojoExecutionException {
        try {
            if (this.killBeforeDown) {
                compose.kill();
            }
            compose.down(this.config());
        }
        catch (JohannException ex) {
            throw new MojoExecutionException("Docker-compose cluster failed to shut down", (Exception)((Object)ex));
        }
    }

    private DownConfig config() {
        return DownConfig.defaults().withRemoveVolumes(this.removeVolumes).withRemoveOrphans(this.removeOrphans).withTimeoutSeconds(this.downTimeoutSeconds);
    }
}

