/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.docker.compose.plugin;

import io.brachu.docker.compose.plugin.AbstractDockerComposeMojo;
import io.brachu.docker.compose.plugin.Config;
import io.brachu.docker.compose.plugin.ExceptionMessages;
import io.brachu.docker.compose.plugin.WaitConfig;
import io.brachu.johann.DockerCompose;
import io.brachu.johann.exception.JohannException;
import io.brachu.johann.exception.JohannTimeoutException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="start", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public final class StartMojo
extends AbstractDockerComposeMojo {
    @Parameter
    private List<String> startServices;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Config config = this.getConfig();
        if (config.shouldExecute()) {
            DockerCompose compose = this.dockerCompose(config);
            this.start(compose, config);
            this.fillProperties(compose);
        } else {
            this.getLog().info((CharSequence)"Skipping.");
        }
    }

    private void start(DockerCompose compose, Config config) throws MojoExecutionException {
        try {
            this.startInternal(compose, config);
        }
        catch (JohannException ex) {
            throw new MojoExecutionException("Unexpected exception during starting of docker-compose services.", (Exception)((Object)ex));
        }
    }

    private void startInternal(DockerCompose compose, Config config) throws MojoExecutionException {
        if (this.startServices != null && !this.startServices.isEmpty()) {
            String[] serviceNames = this.startServices.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
            compose.start(serviceNames);
            this.waitForServices(serviceNames, compose, config.getWait());
        } else {
            compose.startAll();
            this.waitForAll(compose, config.getWait());
        }
    }

    private void waitForServices(String[] serviceNames, DockerCompose compose, WaitConfig wait) throws MojoExecutionException {
        for (String serviceName : serviceNames) {
            try {
                compose.waitForService(serviceName, wait.getValue(), wait.getUnit());
            }
            catch (JohannTimeoutException ex) {
                throw new MojoExecutionException(ExceptionMessages.serviceTimeout(serviceName, ex));
            }
        }
    }

    private void waitForAll(DockerCompose compose, WaitConfig wait) throws MojoExecutionException {
        try {
            compose.waitForCluster(wait.getValue(), wait.getUnit());
        }
        catch (JohannTimeoutException ex) {
            throw new MojoExecutionException(ExceptionMessages.clusterTimeout(ex));
        }
    }
}

