/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.docker.compose.plugin;

import io.brachu.docker.compose.plugin.AbstractDockerComposeMojo;
import io.brachu.docker.compose.plugin.Config;
import io.brachu.johann.DockerCompose;
import io.brachu.johann.exception.JohannException;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="stop", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public final class StopMojo
extends AbstractDockerComposeMojo {
    @Parameter
    private List<String> stopServices;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Config config = this.getConfig();
        if (config.shouldExecute()) {
            DockerCompose compose = this.dockerCompose(config);
            this.stop(compose);
        } else {
            this.getLog().info((CharSequence)"Skipping.");
        }
    }

    private void stop(DockerCompose compose) throws MojoExecutionException {
        try {
            this.stopInternal(compose);
        }
        catch (JohannException ex) {
            throw new MojoExecutionException("Unexpected exception during stopping of docker-compose services.", (Exception)((Object)ex));
        }
    }

    private void stopInternal(DockerCompose compose) {
        if (this.stopServices != null && !this.stopServices.isEmpty()) {
            String[] serviceNames = this.stopServices.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
            compose.stop(serviceNames);
        } else {
            compose.stopAll();
        }
    }
}

