/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.docker.compose.plugin;

import io.brachu.docker.compose.plugin.AbstractDockerComposeMojo;
import io.brachu.docker.compose.plugin.Config;
import io.brachu.docker.compose.plugin.ExceptionMessages;
import io.brachu.docker.compose.plugin.WaitConfig;
import io.brachu.johann.DockerCompose;
import io.brachu.johann.UpConfig;
import io.brachu.johann.exception.JohannException;
import io.brachu.johann.exception.JohannTimeoutException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="up", defaultPhase=LifecyclePhase.PRE_INTEGRATION_TEST)
public final class UpMojo
extends AbstractDockerComposeMojo {
    @Parameter(required=true, defaultValue="false")
    private boolean forceBuild;
    @Parameter(required=true, defaultValue="false")
    private boolean followLogs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Config config = this.getConfig();
        if (config.shouldExecute()) {
            DockerCompose compose = this.dockerCompose(config);
            this.up(compose, config);
            this.fillProperties(compose);
        } else {
            this.getLog().info((CharSequence)"Skipping.");
        }
    }

    private void up(DockerCompose compose, Config config) throws MojoExecutionException {
        WaitConfig wait = config.getWait();
        try {
            compose.up(this.config());
            if (this.followLogs) {
                compose.followLogs();
            }
            compose.waitForCluster(wait.getValue(), wait.getUnit());
        }
        catch (JohannTimeoutException ex) {
            throw new MojoExecutionException(ExceptionMessages.clusterTimeout(ex));
        }
        catch (JohannException ex) {
            throw new MojoExecutionException("Docker-compose cluster failed to start", (Exception)((Object)ex));
        }
    }

    private UpConfig config() {
        return UpConfig.defaults().withForceBuild(this.forceBuild);
    }
}

