/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann;

import io.brachu.johann.ContainerId;
import io.brachu.johann.ContainerPort;
import io.brachu.johann.DownConfig;
import io.brachu.johann.Protocol;
import io.brachu.johann.UpConfig;
import io.brachu.johann.cli.DockerComposeCliBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public interface DockerCompose
extends Closeable {
    public void up();

    public void up(UpConfig var1);

    public void down();

    public void down(DownConfig var1);

    public void kill();

    public boolean isUp();

    public String containerIp(String var1);

    public String containerIp(String var1, String var2);

    public ContainerPort port(String var1, int var2);

    public ContainerPort port(String var1, Protocol var2, int var3);

    public List<ContainerId> ps();

    public List<ContainerId> ps(String var1);

    public void waitForCluster(long var1, TimeUnit var3);

    public void startAll();

    public void start(String var1);

    public void start(String ... var1);

    public void stopAll();

    public void stop(String var1);

    public void stop(String ... var1);

    public void followLogs();

    public void followLogs(PrintStream var1, PrintStream var2);

    public void waitForService(String var1, long var2, TimeUnit var4);

    public String getProjectName();

    public static Builder builder() {
        return DockerCompose.builder("docker-compose");
    }

    public static Builder builder(String executablePath) {
        return new DockerComposeCliBuilder(executablePath);
    }

    public static interface Builder
    extends OngoingBuild.ComposeFile {
    }

    public static interface OngoingBuild {

        public static interface Finish {
            public DockerCompose build();
        }

        public static interface Env
        extends Finish {
            public Env env(String var1, String var2);

            public Env env(Map<String, String> var1);
        }

        public static interface WorkDir
        extends Env {
            public Env workDir(String var1);

            public Env workDir(File var1);
        }

        public static interface Project
        extends WorkDir {
            public WorkDir projectName(String var1);
        }

        public static interface ComposeFile {
            default public Project classpath() {
                return this.classpath("/docker-compose.yml");
            }

            public Project classpath(String var1);

            public Project absolute(String var1);
        }
    }
}

