/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann;

import io.brachu.johann.RemoveImagesMode;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;

public final class DownConfig {
    private static final DownConfig DEFAULT_INSTANCE = new DownConfig();
    private static final int DEFAULT_TIMEOUT = 10;
    private final boolean killBeforeDown;
    private final RemoveImagesMode removeImages;
    private final boolean removeVolumes;
    private final boolean removeOrphans;
    private final int timeoutSeconds;

    private DownConfig() {
        this.killBeforeDown = false;
        this.removeImages = RemoveImagesMode.NONE;
        this.removeVolumes = true;
        this.removeOrphans = false;
        this.timeoutSeconds = 10;
    }

    private DownConfig(boolean killBeforeDown, RemoveImagesMode removeImages, boolean removeVolumes, boolean removeOrphans, int timeoutSeconds) {
        Validate.isTrue((timeoutSeconds > 0 ? 1 : 0) != 0, (String)"timeoutSeconds <= 0", (Object[])new Object[0]);
        this.killBeforeDown = killBeforeDown;
        this.removeImages = removeImages;
        this.removeVolumes = removeVolumes;
        this.removeOrphans = removeOrphans;
        this.timeoutSeconds = timeoutSeconds;
    }

    public static DownConfig defaults() {
        return DEFAULT_INSTANCE;
    }

    public DownConfig withKillBeforeDown() {
        return new DownConfig(true, this.removeImages, this.removeVolumes, this.removeOrphans, this.timeoutSeconds);
    }

    public DownConfig withRemoveImages(RemoveImagesMode mode) {
        return new DownConfig(this.killBeforeDown, mode, this.removeVolumes, this.removeOrphans, this.timeoutSeconds);
    }

    public DownConfig withRemoveVolumes(boolean removeVolumes) {
        return new DownConfig(this.killBeforeDown, this.removeImages, removeVolumes, this.removeOrphans, this.timeoutSeconds);
    }

    public DownConfig withRemoveOrphans(boolean removeOrphans) {
        return new DownConfig(this.killBeforeDown, this.removeImages, this.removeVolumes, removeOrphans, this.timeoutSeconds);
    }

    public DownConfig withTimeoutSeconds(int timeoutSeconds) {
        return new DownConfig(this.killBeforeDown, this.removeImages, this.removeVolumes, this.removeOrphans, timeoutSeconds);
    }

    public String[] toCmd() {
        ArrayList<String> cliString = new ArrayList<String>();
        if (this.removeImages != RemoveImagesMode.NONE) {
            cliString.add("--rmi");
            cliString.add(this.removeImages.toCmd());
        }
        if (this.removeVolumes) {
            cliString.add("-v");
        }
        if (this.removeOrphans) {
            cliString.add("--remove-orphans");
        }
        if (this.timeoutSeconds != 10) {
            cliString.add("-t");
            cliString.add(String.valueOf(this.timeoutSeconds));
        }
        return cliString.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }
}

