/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann.cli;

import io.brachu.johann.cli.ProcessOutputSink;
import io.brachu.johann.cli.ProcessOutputSinkFactory;
import io.brachu.johann.cli.ProcessWaitStrategy;
import io.brachu.johann.cli.exception.NonZeroExitCodeException;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CliRunner {
    private static final Logger log = LoggerFactory.getLogger(CliRunner.class);
    private final String[] cmd;
    private File workDir;
    private Map<String, String> env;
    private ProcessOutputSinkFactory outputSinkFactory = process -> {
        throw new IllegalStateException("ProcessOutputSinkFactory has not been set");
    };
    private Consumer<Process> onProcessStart = process -> {
        throw new IllegalStateException("OnProcessStart consumer has not been set");
    };
    private ProcessWaitStrategy waitStrategy = process -> {
        throw new IllegalStateException("Process wait strategy has not been set");
    };

    CliRunner(String[] cmd) {
        this.cmd = cmd;
        this.env = Collections.emptyMap();
    }

    CliRunner workDir(File workDir) {
        this.workDir = workDir;
        return this;
    }

    CliRunner env(Map<String, String> env) {
        this.env = Map.copyOf(env);
        return this;
    }

    CliRunner outputSinkFactory(ProcessOutputSinkFactory outputSinkFactory) {
        this.outputSinkFactory = outputSinkFactory;
        return this;
    }

    CliRunner onProcessStart(Consumer<Process> onProcessStart) {
        this.onProcessStart = onProcessStart;
        return this;
    }

    CliRunner waitStrategy(ProcessWaitStrategy waitStrategy) {
        this.waitStrategy = waitStrategy;
        return this;
    }

    String exec() throws InterruptedException, IOException, NonZeroExitCodeException, TimeoutException {
        this.log(this.cmd, this.env);
        Process process = this.startProcess();
        ProcessOutputSink outputSink = this.outputSinkFactory.create(process);
        this.onProcessStart.accept(process);
        try {
            return this.waitForProcess(process, outputSink);
        }
        catch (InterruptedException | TimeoutException ex) {
            process.destroy();
            throw ex;
        }
    }

    private String waitForProcess(Process process, ProcessOutputSink outputSink) throws InterruptedException, IOException, NonZeroExitCodeException, TimeoutException {
        int exitCode = this.waitStrategy.waitFor(process);
        if (exitCode == 0) {
            return outputSink.standardOutput();
        }
        String error = outputSink.errorOutput();
        throw new NonZeroExitCodeException(exitCode, error);
    }

    private Process startProcess() throws IOException {
        ProcessBuilder bp = new ProcessBuilder(this.cmd);
        bp.directory(this.workDir);
        bp.environment().putAll(this.env);
        return bp.start();
    }

    private void log(String[] cmd, Map<String, String> env) {
        if (log.isTraceEnabled()) {
            log.trace("Running command: {}", (Object)String.join((CharSequence)" ", cmd));
            log.trace("Env variables: {}", (Object)env.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(" ")));
        }
    }
}

