/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann.cli;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.HealthState;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ContainerNetwork;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import com.github.dockerjava.transport.DockerHttpClient;
import io.brachu.johann.ContainerId;
import io.brachu.johann.ContainerPort;
import io.brachu.johann.DockerCompose;
import io.brachu.johann.DownConfig;
import io.brachu.johann.PortBinding;
import io.brachu.johann.Protocol;
import io.brachu.johann.UpConfig;
import io.brachu.johann.cli.DockerComposeCliExecutor;
import io.brachu.johann.cli.PrintStreamProcessOutputSink;
import io.brachu.johann.cli.SystemProcessOutputSink;
import io.brachu.johann.exception.DockerComposeException;
import io.brachu.johann.exception.JohannTimeoutException;
import io.brachu.johann.project.ProjectNameProvider;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerComposeCli
implements DockerCompose {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeCli.class);
    private final String projectName;
    private final DockerComposeCliExecutor composeExecutor;
    private final DockerClientConfig dockerClientConfig;
    private final DockerClient dockerClient;

    DockerComposeCli(String executablePath, File file, File workDir, ProjectNameProvider projectNameProvider, Map<String, String> env) {
        this.projectName = projectNameProvider.provide();
        this.composeExecutor = new DockerComposeCliExecutor(executablePath, file, workDir, this.projectName, env);
        this.dockerClientConfig = this.createDockerClientConfig();
        this.dockerClient = this.createDockerClient(this.dockerClientConfig);
    }

    @Override
    public void up() {
        this.up(UpConfig.defaults());
    }

    @Override
    public void up(UpConfig config) {
        if (this.isUp()) {
            log.info("Executing 'up' command for a cluster that is already up.");
        }
        this.composeExecutor.up(config);
    }

    @Override
    public void down() {
        this.down(DownConfig.defaults());
    }

    @Override
    public void down(DownConfig config) {
        if (!this.isUp()) {
            log.info("Executing 'down' command for a cluster that is already down.");
        }
        this.composeExecutor.down(config);
    }

    @Override
    public void kill() {
        if (!this.isUp()) {
            log.info("Executing 'kill' command for a cluster that is already down.");
        }
        this.composeExecutor.kill();
    }

    @Override
    public boolean isUp() {
        return !this.composeExecutor.ps().isEmpty();
    }

    @Override
    public String containerIp(String serviceName) {
        return this.containerIp(serviceName, this.projectName.toLowerCase() + "_default");
    }

    @Override
    public String containerIp(String serviceName, String networkName) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        List<ContainerId> containerIds = this.ps(serviceName);
        Validate.isTrue((!containerIds.isEmpty() ? 1 : 0) != 0, (String)(serviceName + " service is not present in the cluster"), (Object[])new Object[0]);
        ContainerId containerId = containerIds.get(0);
        InspectContainerResponse response = this.dockerClient.inspectContainerCmd(containerId.toString()).exec();
        Map networks = response.getNetworkSettings().getNetworks();
        if (networks != null) {
            ContainerNetwork network = (ContainerNetwork)networks.get(networkName);
            if (network != null) {
                return network.getIpAddress();
            }
            throw new DockerComposeException("Service " + serviceName + "is not bound to " + networkName + " network. Have you provided a correct network name?");
        }
        throw new DockerComposeException("Unexpected lack of networks for container with id " + containerId + ".");
    }

    @Override
    public ContainerPort port(String serviceName, int privatePort) {
        return this.port(serviceName, Protocol.TCP, privatePort);
    }

    @Override
    public ContainerPort port(String serviceName, Protocol protocol, int privatePort) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        PortBinding binding = this.composeExecutor.binding(serviceName, protocol, privatePort);
        return new ContainerPort(this.dockerClientConfig.getDockerHost(), binding);
    }

    @Override
    public List<ContainerId> ps() {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        return this.composeExecutor.ps();
    }

    @Override
    public List<ContainerId> ps(String serviceName) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        return this.composeExecutor.ps(serviceName);
    }

    @Override
    public void waitForCluster(long time, TimeUnit unit) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        Validate.isTrue((unit.ordinal() >= TimeUnit.SECONDS.ordinal() ? 1 : 0) != 0, (String)"Time unit cannot be smaller than SECONDS", (Object[])new Object[0]);
        Validate.isTrue((time > 0L ? 1 : 0) != 0, (String)"Time to wait must be positive", (Object[])new Object[0]);
        log.debug("Waiting for cluster to be healthy");
        try {
            Awaitility.await().pollInterval(500L, TimeUnit.MILLISECONDS).atMost(time, unit).until(this::containersHealthyOrRunning);
        }
        catch (ConditionTimeoutException ex) {
            this.down();
            throw new JohannTimeoutException("Timed out while waiting for cluster to be healthy.", time, unit, ex);
        }
        catch (Exception ex) {
            this.down();
            throw new DockerComposeException("Unexpected exception while waiting for cluster to be healthy.", ex);
        }
        log.debug("Cluster appears to be healthy");
    }

    @Override
    public void startAll() {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        this.composeExecutor.startAll();
    }

    @Override
    public void start(String serviceName) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        this.composeExecutor.start(serviceName);
    }

    @Override
    public void start(String ... serviceNames) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        this.composeExecutor.start(serviceNames);
    }

    @Override
    public void stopAll() {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        this.composeExecutor.stopAll();
    }

    @Override
    public void stop(String serviceName) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        this.composeExecutor.stop(serviceName);
    }

    @Override
    public void stop(String ... serviceNames) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        this.composeExecutor.stop(serviceNames);
    }

    @Override
    public void followLogs() {
        this.composeExecutor.followLogs(SystemProcessOutputSink::create);
    }

    @Override
    public void followLogs(PrintStream out, PrintStream err) {
        Validate.notNull((Object)out, (String)"out == null", (Object[])new Object[0]);
        Validate.notNull((Object)err, (String)"err == null", (Object[])new Object[0]);
        this.composeExecutor.followLogs(process -> PrintStreamProcessOutputSink.create(process, out, err));
    }

    @Override
    public void waitForService(String serviceName, long time, TimeUnit unit) {
        Validate.isTrue((boolean)this.isUp(), (String)"Cluster is not up", (Object[])new Object[0]);
        Validate.isTrue((unit.ordinal() >= TimeUnit.SECONDS.ordinal() ? 1 : 0) != 0, (String)"Time unit cannot be smaller than SECONDS", (Object[])new Object[0]);
        Validate.isTrue((time > 0L ? 1 : 0) != 0, (String)"Time to wait must be positive", (Object[])new Object[0]);
        log.debug("Waiting for service " + serviceName + " to be healthy");
        try {
            Awaitility.await().pollInterval(500L, TimeUnit.MILLISECONDS).atMost(time, unit).until(() -> this.containersHealthyOrRunning(this.ps(serviceName)));
        }
        catch (ConditionTimeoutException ex) {
            throw new JohannTimeoutException("Timed out while waiting for cluster to be healthy.", time, unit, ex);
        }
        catch (Exception ex) {
            throw new DockerComposeException("Unexpected exception while waiting for cluster to be healthy.", ex);
        }
        log.debug("Service " + serviceName + " appears to be healthy");
    }

    @Override
    public String getProjectName() {
        return this.composeExecutor.getProjectName();
    }

    @Override
    public void close() throws IOException {
        this.dockerClient.close();
    }

    private DockerClientConfig createDockerClientConfig() {
        return DefaultDockerClientConfig.createDefaultConfigBuilder().build();
    }

    private DockerHttpClient createDockerHttpClient(DockerClientConfig config) {
        return new ApacheDockerHttpClient.Builder().dockerHost(config.getDockerHost()).connectionTimeout(Duration.ofSeconds(1L)).responseTimeout(Duration.ofSeconds(10L)).build();
    }

    private DockerClient createDockerClient(DockerClientConfig config) {
        DockerHttpClient httpClient = this.createDockerHttpClient(config);
        return DockerClientImpl.getInstance((DockerClientConfig)config, (DockerHttpClient)httpClient);
    }

    private boolean containersHealthyOrRunning() {
        return this.containersHealthyOrRunning(this.ps());
    }

    private boolean containersHealthyOrRunning(List<ContainerId> containerIds) {
        for (ContainerId id : containerIds) {
            String healthStatus;
            InspectContainerResponse response = this.dockerClient.inspectContainerCmd(id.toString()).exec();
            String status = response.getState().getStatus();
            HealthState health = response.getState().getHealth();
            String string = healthStatus = health != null ? health.getStatus() : "unsupported";
            if ("running".equals(status) && ("healthy".equals(healthStatus) || "unsupported".equals(healthStatus))) continue;
            return false;
        }
        return true;
    }
}

