/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann.cli;

import io.brachu.johann.DockerCompose;
import io.brachu.johann.cli.DockerComposeCli;
import io.brachu.johann.cli.EnvRetriever;
import io.brachu.johann.exception.ComposeFileNotFoundException;
import io.brachu.johann.exception.DockerComposeException;
import io.brachu.johann.project.ExplicitProjectNameProvider;
import io.brachu.johann.project.ImplicitProjectNameProvider;
import io.brachu.johann.project.ProjectNameProvider;
import java.io.File;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Map;

public class DockerComposeCliBuilder
implements DockerCompose.Builder {
    private final String executablePath;
    private File file;
    private File workDir;
    private ProjectNameProvider projectNameProvider;
    private Map<String, String> env;

    public DockerComposeCliBuilder(String executablePath) {
        this.executablePath = executablePath;
        this.projectNameProvider = new ImplicitProjectNameProvider();
        this.env = new LinkedHashMap<String, String>();
    }

    @Override
    public DockerCompose.OngoingBuild.Project classpath(String filePath) {
        URL url = this.getClass().getResource(filePath);
        if (url != null) {
            File file = new File(url.getPath());
            this.assertFileExistence(file);
            this.file = file;
            return new Project();
        }
        throw new ComposeFileNotFoundException("File " + filePath + " not found in the classpath.");
    }

    @Override
    public DockerCompose.OngoingBuild.Project absolute(String filePath) {
        File file = new File(filePath);
        this.assertFileExistence(file);
        this.file = file;
        return new Project();
    }

    private void assertFileExistence(File file) {
        if (!file.exists()) {
            throw new ComposeFileNotFoundException("File " + file.getAbsolutePath() + " does not exist.");
        }
    }

    private void assertDirectoryExistence(File file) {
        if (!file.isDirectory()) {
            throw new DockerComposeException("Path " + file.getAbsolutePath() + " does not point to a directory");
        }
    }

    private class Project
    extends WorkDir
    implements DockerCompose.OngoingBuild.Project {
        private Project() {
        }

        @Override
        public DockerCompose.OngoingBuild.WorkDir projectName(String projectName) {
            DockerComposeCliBuilder.this.projectNameProvider = new ExplicitProjectNameProvider(projectName);
            return this;
        }
    }

    private class Finish
    implements DockerCompose.OngoingBuild.Finish {
        private EnvRetriever envRetriever = new EnvRetriever();

        private Finish() {
        }

        @Override
        public DockerCompose build() {
            this.importSystemEnv();
            return new DockerComposeCli(DockerComposeCliBuilder.this.executablePath, DockerComposeCliBuilder.this.file, DockerComposeCliBuilder.this.workDir, DockerComposeCliBuilder.this.projectNameProvider, DockerComposeCliBuilder.this.env);
        }

        private void importSystemEnv() {
            String dockerHost = this.envRetriever.retrieveDockerHost();
            String tlsVerify = this.envRetriever.retrieveTlsVerify();
            String certPath = this.envRetriever.retrieveCertPath();
            if (dockerHost != null && !DockerComposeCliBuilder.this.env.containsKey("DOCKER_HOST")) {
                DockerComposeCliBuilder.this.env.put("DOCKER_HOST", dockerHost);
            }
            if (tlsVerify != null && !DockerComposeCliBuilder.this.env.containsKey("DOCKER_TLS_VERIFY")) {
                DockerComposeCliBuilder.this.env.put("DOCKER_TLS_VERIFY", tlsVerify);
            }
            if (certPath != null && !DockerComposeCliBuilder.this.env.containsKey("DOCKER_CERT_PATH")) {
                DockerComposeCliBuilder.this.env.put("DOCKER_CERT_PATH", certPath);
            }
        }
    }

    private class Env
    extends Finish
    implements DockerCompose.OngoingBuild.Env {
        private Env() {
        }

        @Override
        public DockerCompose.OngoingBuild.Env env(String key, String value) {
            DockerComposeCliBuilder.this.env.put(key, value);
            return this;
        }

        @Override
        public DockerCompose.OngoingBuild.Env env(Map<String, String> env) {
            DockerComposeCliBuilder.this.env.putAll(env);
            return this;
        }
    }

    private class WorkDir
    extends Env
    implements DockerCompose.OngoingBuild.WorkDir {
        private WorkDir() {
        }

        @Override
        public DockerCompose.OngoingBuild.Env workDir(String workDir) {
            return this.workDir(new File(workDir));
        }

        @Override
        public DockerCompose.OngoingBuild.Env workDir(File workDir) {
            DockerComposeCliBuilder.this.assertDirectoryExistence(workDir);
            DockerComposeCliBuilder.this.workDir = workDir;
            return this;
        }
    }
}

