/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann.cli;

import io.brachu.johann.ContainerId;
import io.brachu.johann.DownConfig;
import io.brachu.johann.PortBinding;
import io.brachu.johann.Protocol;
import io.brachu.johann.UpConfig;
import io.brachu.johann.cli.CliRunner;
import io.brachu.johann.cli.OnDemandProcessOutputSink;
import io.brachu.johann.cli.ProcessOutputSinkFactory;
import io.brachu.johann.cli.ProcessWaitStrategy;
import io.brachu.johann.cli.SystemProcessOutputSink;
import io.brachu.johann.cli.TimedProcessWaitStrategy;
import io.brachu.johann.cli.exception.NonZeroExitCodeException;
import io.brachu.johann.exception.DockerComposeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DockerComposeCliExecutor {
    private static final Logger log = LoggerFactory.getLogger(DockerComposeCliExecutor.class);
    private static final String[] UP_COMMAND = new String[]{"up", "-d"};
    private static final String[] DOWN_COMMAND = new String[]{"down"};
    private static final String[] KILL_COMMAND = new String[]{"kill"};
    private static final String[] PORT_COMMAND = new String[]{"port"};
    private static final String[] PS_COMMAND = new String[]{"ps", "-q"};
    private static final String[] START_COMMAND = new String[]{"start"};
    private static final String[] STOP_COMMAND = new String[]{"stop"};
    private static final String[] FOLLOW_LOGS_COMMAND = new String[]{"logs", "-f"};
    private static final ProcessWaitStrategy DEFAULT_PROCESS_WAIT_STRATEGY = new TimedProcessWaitStrategy(5L, TimeUnit.MINUTES);
    private static final ProcessWaitStrategy NOOP_PROCESS_WAIT_STRATEGY = process -> 0;
    private final String projectName;
    private final String composeFileContent;
    private final File workDir;
    private final Map<String, String> env;
    private final String[] upCmd;
    private final String[] downCmd;
    private final String[] killCmd;
    private final String[] portCmd;
    private final String[] psCmd;
    private final String[] startCmd;
    private final String[] stopCmd;
    private final String[] followLogsCmd;

    DockerComposeCliExecutor(String executablePath, File composeFile, File workDir, String projectName, Map<String, String> env) {
        this.projectName = projectName;
        this.composeFileContent = this.readComposeFile(composeFile);
        this.workDir = workDir;
        this.env = Map.copyOf(env);
        String[] cmdPrefix = this.createCmdPrefix(executablePath, projectName);
        this.upCmd = this.concat(cmdPrefix, UP_COMMAND);
        this.downCmd = this.concat(cmdPrefix, DOWN_COMMAND);
        this.killCmd = this.concat(cmdPrefix, KILL_COMMAND);
        this.portCmd = this.concat(cmdPrefix, PORT_COMMAND);
        this.psCmd = this.concat(cmdPrefix, PS_COMMAND);
        this.startCmd = this.concat(cmdPrefix, START_COMMAND);
        this.stopCmd = this.concat(cmdPrefix, STOP_COMMAND);
        this.followLogsCmd = this.concat(cmdPrefix, FOLLOW_LOGS_COMMAND);
    }

    String getProjectName() {
        return this.projectName;
    }

    void up(UpConfig config) {
        log.debug("Starting cluster");
        this.exec(this.concat(this.upCmd, config.toCmd()), this.standardSink());
    }

    void down(DownConfig config) {
        log.debug("Shutting down cluster");
        this.exec(this.concat(this.downCmd, config.toCmd()), this.standardSink());
        log.debug("Cluster shut down");
    }

    void kill() {
        log.debug("Killing cluster");
        this.exec(this.killCmd, this.standardSink());
        log.debug("Cluster killed");
    }

    PortBinding binding(String serviceName, Protocol protocol, int privatePort) {
        String[] params = new String[]{"--protocol", protocol.toString(), serviceName, String.valueOf(privatePort)};
        String binding = StringUtils.trim((String)this.exec(this.concat(this.portCmd, params), this.resultSink()));
        if (PortBinding.isBound(binding)) {
            return new PortBinding(binding);
        }
        throw new DockerComposeException("No host port is bound to '" + serviceName + "' container's " + privatePort + " " + protocol.toString() + " port.");
    }

    List<ContainerId> ps() {
        String[] ids = this.exec(this.psCmd, this.resultSink()).split(System.lineSeparator());
        return Arrays.stream(ids).filter(StringUtils::isNotBlank).map(ContainerId::new).collect(Collectors.toList());
    }

    List<ContainerId> ps(String serviceName) {
        String[] params = new String[]{serviceName};
        String[] ids = this.exec(this.concat(this.psCmd, params), this.resultSink()).split(System.lineSeparator());
        return Arrays.stream(ids).filter(StringUtils::isNotBlank).map(ContainerId::new).collect(Collectors.toList());
    }

    void startAll() {
        log.debug("Starting all services");
        this.exec(this.startCmd, this.standardSink());
        log.debug("Started all services");
    }

    void start(String serviceName) {
        log.debug("Starting " + serviceName + " service");
        String[] params = new String[]{serviceName};
        this.exec(this.concat(this.startCmd, params), this.standardSink());
        log.debug("Started " + serviceName + " service");
    }

    void start(String ... serviceNames) {
        String services = String.join((CharSequence)", ", serviceNames);
        log.debug("Starting services: " + services);
        this.exec(this.concat(this.startCmd, serviceNames), this.standardSink());
        log.debug("Started services: " + services);
    }

    void stopAll() {
        log.debug("Stopping all services");
        this.exec(this.stopCmd, this.standardSink());
        log.debug("Stopped all services");
    }

    void stop(String serviceName) {
        log.debug("Stopping " + serviceName + " service");
        String[] params = new String[]{serviceName};
        this.exec(this.concat(this.stopCmd, params), this.standardSink());
        log.debug("Stopped " + serviceName + " service");
    }

    void stop(String ... serviceNames) {
        String services = String.join((CharSequence)", ", serviceNames);
        log.debug("Stopping services: " + services);
        this.exec(this.concat(this.stopCmd, serviceNames), this.standardSink());
        log.debug("Stopped services: " + services);
    }

    void followLogs(ProcessOutputSinkFactory sinkFactory) {
        log.debug("Following logs of all services");
        this.exec(this.followLogsCmd, sinkFactory, NOOP_PROCESS_WAIT_STRATEGY);
    }

    private String[] createCmdPrefix(String executablePath, String projectName) {
        return new String[]{executablePath, "--ansi", "never", "-f", "-", "-p", projectName};
    }

    private String exec(String[] cmd, ProcessOutputSinkFactory sinkFactory) {
        return this.exec(cmd, sinkFactory, DEFAULT_PROCESS_WAIT_STRATEGY);
    }

    private String exec(String[] cmd, ProcessOutputSinkFactory sinkFactory, ProcessWaitStrategy waitStrategy) {
        String cmdConcat = String.join((CharSequence)" ", cmd);
        try {
            return new CliRunner(cmd).env(this.env).workDir(this.workDir).outputSinkFactory(sinkFactory).onProcessStart(this::pipeComposeFile).waitStrategy(waitStrategy).exec();
        }
        catch (IOException e) {
            throw new DockerComposeException("Unexpected I/O exception while executing '" + cmdConcat + "'.", e);
        }
        catch (InterruptedException e) {
            throw new DockerComposeException("Interrupted unexpectedly while executing '" + cmdConcat + "'.");
        }
        catch (TimeoutException e) {
            throw new DockerComposeException("Timed out while waiting for '" + cmdConcat + "' to finish executing.");
        }
        catch (NonZeroExitCodeException e) {
            String msg = String.format("Non-zero (%d) exit code returned from '%s'.%nOutput is:%n%s", e.getExitCode(), cmdConcat, e.getOutput());
            throw new DockerComposeException(msg);
        }
    }

    private String readComposeFile(File composeFile) {
        try {
            return IOUtils.toString((InputStream)new FileInputStream(composeFile), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new DockerComposeException("Unexpected exception while reading compose file contents.", e);
        }
    }

    private void pipeComposeFile(Process process) {
        OutputStream output = process.getOutputStream();
        try {
            IOUtils.write((String)this.composeFileContent, (OutputStream)output, (Charset)StandardCharsets.UTF_8);
            output.flush();
            output.close();
        }
        catch (IOException e) {
            throw new DockerComposeException("Unexpected exception while piping compose file contents to docker-compose CLI.", e);
        }
    }

    private String[] concat(String[] first, String[] second) {
        return (String[])Stream.concat(Arrays.stream(first), Arrays.stream(second)).toArray(String[]::new);
    }

    private ProcessOutputSinkFactory standardSink() {
        return SystemProcessOutputSink::create;
    }

    private ProcessOutputSinkFactory resultSink() {
        return OnDemandProcessOutputSink::new;
    }
}

