/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann.cli;

import io.brachu.johann.cli.ProcessOutputSink;
import io.brachu.johann.cli.ProcessOutputTransfer;
import java.io.PrintStream;

class PrintStreamProcessOutputSink
implements ProcessOutputSink {
    private final PrintStream out;
    private final PrintStream err;
    private final StringBuffer sunkLines;
    private final StringBuffer sunkErrorLines;

    PrintStreamProcessOutputSink(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
        this.sunkLines = new StringBuffer();
        this.sunkErrorLines = new StringBuffer();
    }

    static PrintStreamProcessOutputSink create(Process process, PrintStream out, PrintStream err) {
        PrintStreamProcessOutputSink sink = new PrintStreamProcessOutputSink(out, err);
        ProcessOutputTransfer.start(process, sink);
        return sink;
    }

    @Override
    public void takeLine(String line) {
        this.out.println(line);
        this.sunkLines.append(line).append(System.lineSeparator());
    }

    @Override
    public void takeErrorLine(String line) {
        this.err.println(line);
        this.sunkErrorLines.append(line).append(System.lineSeparator());
    }

    @Override
    public String standardOutput() {
        return this.sunkLines.toString();
    }

    @Override
    public String errorOutput() {
        return this.sunkErrorLines.toString();
    }
}

