/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann.cli;

import io.brachu.johann.cli.ProcessWaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.Validate;

final class TimedProcessWaitStrategy
implements ProcessWaitStrategy {
    private final long timeout;
    private final TimeUnit unit;

    TimedProcessWaitStrategy(long timeout, TimeUnit unit) {
        Validate.isTrue((timeout > 0L ? 1 : 0) != 0, (String)"timeout <= 0", (Object[])new Object[0]);
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public int waitFor(Process process) throws InterruptedException, TimeoutException {
        if (process.waitFor(this.timeout, this.unit)) {
            return process.exitValue();
        }
        throw new TimeoutException("Timed out while waiting for process to exit");
    }
}

