/*
 * Decompiled with CFR 0.152.
 */
package io.brachu.johann.project;

import io.brachu.johann.project.ProjectNameProvider;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class ExplicitProjectNameProvider
implements ProjectNameProvider {
    private static final Pattern VALID_PROJECT_NAME = Pattern.compile("[a-zA-Z0-9_-]+");
    private final String projectName;

    public ExplicitProjectNameProvider(String projectName) {
        Validate.notBlank((CharSequence)projectName, (String)"projectName is null or blank", (Object[])new Object[0]);
        Validate.isTrue((boolean)VALID_PROJECT_NAME.matcher(projectName).matches(), (String)("Due to security reasons, projectName must match " + VALID_PROJECT_NAME.toString() + " regex pattern"), (Object[])new Object[0]);
        this.projectName = projectName;
    }

    @Override
    public String provide() {
        return this.projectName;
    }
}

