/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.catalog.BrooklynCatalog;
import brooklyn.catalog.CatalogItem;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.basic.BasicApplication;
import brooklyn.entity.basic.BasicApplicationImpl;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.EntityTypes;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.InternalEntityFactory;
import brooklyn.entity.trait.Startable;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.text.Strings;
import com.google.common.collect.Maps;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.brooklyn.BrooklynCampPlatform;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynEntityClassResolver;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlLocationResolver;
import io.brooklyn.camp.brooklyn.spi.platform.HasBrooklynManagementContext;
import io.brooklyn.camp.spi.AbstractResource;
import io.brooklyn.camp.spi.Assembly;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.PlatformComponentTemplate;
import io.brooklyn.camp.spi.collection.ResolvableLink;
import io.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import java.lang.reflect.Constructor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynAssemblyTemplateInstantiator
implements AssemblyTemplateInstantiator {
    private static final Logger log = LoggerFactory.getLogger(BrooklynAssemblyTemplateInstantiator.class);

    public Assembly instantiate(AssemblyTemplate template, CampPlatform platform) {
        Application app = this.create(template, platform);
        Task<?> task = this.start(app, platform);
        log.info("CAMP created " + app + "; starting in " + task);
        return (Assembly)((BrooklynCampPlatform)platform).assemblies().get(app.getApplicationId());
    }

    public Application create(AssemblyTemplate template, CampPlatform platform) {
        log.debug("CAMP creating application instance for {} ({})", (Object)template.getId(), (Object)template);
        ManagementContext mgmt = this.getBrooklynManagementContext(platform);
        BrooklynCatalog catalog = mgmt.getCatalog();
        CatalogItem item = catalog.getCatalogItem(template.getId());
        if (item == null) {
            return this.createApplicationFromNonCatalogCampTemplate(template, platform);
        }
        return this.createApplicationFromCatalog(platform, item, template);
    }

    protected Application createApplicationFromCatalog(CampPlatform platform, CatalogItem<?> item, AssemblyTemplate template) {
        ManagementContext mgmt = this.getBrooklynManagementContext(platform);
        if (!template.getApplicationComponentTemplates().isEmpty() || !template.getPlatformComponentTemplates().isEmpty()) {
            log.warn("CAMP AssemblyTemplate was not empty when creating from catalog spec; ignoring templates declared within it (" + template + ")");
        }
        String name = template.getName();
        String type = item.getJavaType();
        Class clazz = Strings.isEmpty((CharSequence)type) ? BasicApplication.class : BrooklynEntityClassResolver.resolveEntity(type, mgmt);
        try {
            Application instance;
            if (ApplicationBuilder.class.isAssignableFrom(clazz)) {
                Constructor constructor = clazz.getConstructor(new Class[0]);
                ApplicationBuilder appBuilder = (ApplicationBuilder)constructor.newInstance(new Object[0]);
                if (!Strings.isEmpty((CharSequence)name)) {
                    appBuilder.appDisplayName(name);
                }
                Map configO = (Map)template.getCustomAttributes().get("brooklyn.config");
                log.info("CAMP placing '{}' under management", (Object)appBuilder);
                appBuilder.configure(BrooklynAssemblyTemplateInstantiator.convertFlagsToKeys(appBuilder.getType(), configO));
                instance = appBuilder.manage(mgmt);
                List<Location> locations = new BrooklynYamlLocationResolver(mgmt).resolveLocations(template.getCustomAttributes(), false);
                if (locations != null) {
                    ((EntityInternal)instance).addLocations(locations);
                }
            } else if (Application.class.isAssignableFrom(clazz)) {
                Map configO = (Map)template.getCustomAttributes().get("brooklyn.config");
                EntitySpec<?> coreSpec = this.toCoreEntitySpec(clazz, name, configO);
                instance = (Application)mgmt.getEntityManager().createEntity(coreSpec);
                log.info("CAMP placing '{}' under management", (Object)instance);
                Entities.startManagement((Application)instance, (ManagementContext)mgmt);
                List<Location> locations = new BrooklynYamlLocationResolver(mgmt).resolveLocations(template.getCustomAttributes(), false);
                if (locations != null) {
                    ((EntityInternal)instance).addLocations(locations);
                }
            } else {
                throw new IllegalArgumentException("Class " + clazz + " must extend one of ApplicationBuilder or Application");
            }
            return instance;
        }
        catch (Exception e) {
            log.error("CAMP failed to create application: " + e, (Throwable)e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private ManagementContext getBrooklynManagementContext(CampPlatform platform) {
        ManagementContext mgmt = ((HasBrooklynManagementContext)platform).getBrooklynManagementContext();
        return mgmt;
    }

    public Task<?> start(Application app, CampPlatform platform) {
        return Entities.invokeEffector((EntityLocal)((EntityLocal)app), (Entity)app, (Effector)Startable.START, (Map)MutableMap.of((Object)"locations", (Object)MutableList.of()));
    }

    private static Map<?, ?> convertFlagsToKeys(Class<? extends Entity> javaType, Map<?, ?> config) {
        if (config == null || config.isEmpty() || javaType == null) {
            return config;
        }
        Map configKeys = EntityTypes.getDefinedConfigKeys(javaType);
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry<?, ?> entry : config.entrySet()) {
            log.debug("Setting key {} to {} for CAMP creation of {}", new Object[]{entry.getKey(), entry.getValue(), javaType});
            Object key = configKeys.get(entry.getKey());
            if (key == null) {
                log.warn("Unrecognised config key {} passed to {}; will be treated as flag (and likely ignored)", entry.getKey(), javaType);
                key = entry.getKey();
            }
            result.put(key, entry.getValue());
        }
        return result;
    }

    private <T extends Entity> EntitySpec<?> toCoreEntitySpec(Class<T> clazz, String name, Map<?, ?> configO) {
        EntitySpec result;
        LinkedHashMap config;
        LinkedHashMap linkedHashMap = config = configO == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap(configO);
        if (clazz.isInterface()) {
            result = EntitySpec.create(clazz);
        } else {
            Class interfaceclazz = Application.class.isAssignableFrom(clazz) ? Application.class : Entity.class;
            Class[] additionalInterfaceClazzes = clazz.getInterfaces();
            result = EntitySpec.create(interfaceclazz).impl(clazz).additionalInterfaces(additionalInterfaceClazzes);
        }
        if (!Strings.isEmpty((CharSequence)name)) {
            result.displayName(name);
        }
        result.configure(BrooklynAssemblyTemplateInstantiator.convertFlagsToKeys(result.getImplementation(), config));
        return result;
    }

    protected void buildEntityHierarchy(ManagementContext mgmt, Map<Entity, EntitySpec<?>> entitySpecs, Entity parent, List<Map<String, Object>> childConfig) {
        if (childConfig != null) {
            for (Map<String, Object> childAttrs : childConfig) {
                BrooklynComponentTemplateResolver entityResolver = BrooklynComponentTemplateResolver.Factory.newInstance(mgmt, childAttrs);
                EntitySpec spec = entityResolver.resolveSpec();
                spec.parent(parent);
                Object entity = entityResolver.newEntity(spec);
                entitySpecs.put((Entity)entity, spec);
                this.buildEntityHierarchy(mgmt, entitySpecs, (Entity)entity, entityResolver.getChildren(childAttrs));
            }
        }
    }

    protected Application createApplicationFromNonCatalogCampTemplate(AssemblyTemplate template, CampPlatform platform) {
        final ManagementContext mgmt = this.getBrooklynManagementContext(platform);
        LinkedHashMap entitySpecs = Maps.newLinkedHashMap();
        BrooklynComponentTemplateResolver appResolver = BrooklynComponentTemplateResolver.Factory.newInstance(mgmt, (AbstractResource)template);
        EntitySpec<BasicApplicationImpl> appSpec = appResolver.resolveSpec(StartableApplication.class, BasicApplicationImpl.class);
        Application app = (Application)appResolver.newEntity(appSpec);
        entitySpecs.put(app, appSpec);
        for (ResolvableLink ctl : template.getPlatformComponentTemplates().links()) {
            PlatformComponentTemplate appChildComponentTemplate = (PlatformComponentTemplate)ctl.resolve();
            BrooklynComponentTemplateResolver entityResolver = BrooklynComponentTemplateResolver.Factory.newInstance(mgmt, (AbstractResource)appChildComponentTemplate);
            EntitySpec spec = entityResolver.resolveSpec();
            spec.parent((Entity)app);
            Object entity = entityResolver.newEntity(spec);
            entitySpecs.put(entity, spec);
            this.buildEntityHierarchy(mgmt, entitySpecs, (Entity)entity, entityResolver.getChildren(appChildComponentTemplate.getCustomAttributes()));
        }
        for (final Entity entity : entitySpecs.keySet()) {
            final EntitySpec spec = (EntitySpec)entitySpecs.get(entity);
            ((EntityInternal)entity).getExecutionContext().submit((Map)MutableMap.of(), new Runnable(){

                @Override
                public void run() {
                    BrooklynAssemblyTemplateInstantiator.this.initEntity(mgmt, entity, spec);
                }
            }).getUnchecked();
        }
        log.info("CAMP placing '{}' under management", appSpec);
        Entities.startManagement((Application)app, (ManagementContext)mgmt);
        return app;
    }

    protected <T extends Entity> void initEntity(ManagementContext mgmt, T entity, EntitySpec<T> spec) {
        InternalEntityFactory entityFactory = ((ManagementContextInternal)mgmt).getEntityFactory();
        entityFactory.initEntity(entity, spec);
    }
}

