/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractApplication;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.VanillaSoftwareProcess;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.group.DynamicRegionsFabric;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.InternalEntityFactory;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.guava.Maybe;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.brooklyn.camp.brooklyn.BrooklynCampConstants;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynEntityClassResolver;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynYamlLocationResolver;
import io.brooklyn.camp.brooklyn.spi.creation.ChefComponentTemplateResolver;
import io.brooklyn.camp.brooklyn.spi.creation.EntitySpecConfiguration;
import io.brooklyn.camp.spi.AbstractResource;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynComponentTemplateResolver {
    private static final Logger log = LoggerFactory.getLogger(BrooklynComponentTemplateResolver.class);
    final ManagementContext mgmt;
    final ConfigBag attrs;
    final Maybe<AbstractResource> template;
    AtomicBoolean alreadyBuilt = new AtomicBoolean(false);

    public BrooklynComponentTemplateResolver(ManagementContext mgmt, ConfigBag attrs, AbstractResource optionalTemplate) {
        this.mgmt = mgmt;
        this.attrs = ConfigBag.newInstanceCopying((ConfigBag)attrs);
        this.template = Maybe.fromNullable((Object)optionalTemplate);
    }

    protected String getDeclaredType() {
        return Factory.getDeclaredType(null, (AbstractResource)this.template.orNull(), this.attrs);
    }

    protected String getJavaType() {
        String type = this.getDeclaredType();
        if ((type = Strings.removeFromStart((String)type, (String[])new String[]{"brooklyn:", "java:"})).equals("cluster") || type.equals("Cluster")) {
            return DynamicCluster.class.getName();
        }
        if (type.equals("fabric") || type.equals("Fabric")) {
            return DynamicRegionsFabric.class.getName();
        }
        if (type.equals("vanilla") || type.equals("Vanilla")) {
            return VanillaSoftwareProcess.class.getName();
        }
        if (type.equals("web-app-cluster") || type.equals("WebAppCluster")) {
            return "brooklyn.entity.webapp.ControlledDynamicWebAppCluster";
        }
        return type;
    }

    public <T extends Entity> Class<T> loadEntityClass() {
        return this.loadClass(Entity.class, this.getJavaType());
    }

    public <T extends Entity> EntitySpec<T> resolveSpec() {
        return this.resolveSpec(this.loadEntityClass(), null);
    }

    public <T extends Entity> EntitySpec<T> resolveSpec(Class<T> type, Class<? extends T> optionalImpl) {
        List<Location> childLocations;
        String name;
        if (this.alreadyBuilt.getAndSet(true)) {
            throw new IllegalStateException("Spec can only be used once: " + this);
        }
        EntitySpec spec = EntitySpec.create(type);
        if (optionalImpl != null) {
            spec.impl(optionalImpl);
        }
        String templateId = null;
        String planId = null;
        if (this.template.isPresent()) {
            name = ((AbstractResource)this.template.get()).getName();
            templateId = ((AbstractResource)this.template.get()).getId();
        } else {
            name = (String)this.attrs.getStringKey("name");
        }
        planId = (String)this.attrs.getStringKey("id");
        if (planId == null) {
            planId = (String)this.attrs.getStringKey("planId");
        }
        if (!Strings.isBlank((CharSequence)name)) {
            spec.displayName(name);
        }
        if (templateId != null) {
            spec.configure(BrooklynCampConstants.TEMPLATE_ID, (Object)templateId);
        }
        if (planId != null) {
            spec.configure(BrooklynCampConstants.PLAN_ID, (Object)planId);
        }
        if ((childLocations = new BrooklynYamlLocationResolver(this.mgmt).resolveLocations(this.attrs.getAllConfig(), true)) != null) {
            spec.locations(childLocations);
        }
        this.decorateSpec(spec);
        return spec;
    }

    protected <T> Class<T> loadClass(Class<T> optionalSupertype, String typeName) {
        try {
            if (optionalSupertype != null && Entity.class.isAssignableFrom(optionalSupertype)) {
                return BrooklynEntityClassResolver.resolveEntity(typeName, this.mgmt);
            }
            return (Class)BrooklynEntityClassResolver.tryLoadFromClasspath(typeName, this.mgmt).get();
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Unable to resolve " + typeName + " in spec " + this);
            throw Exceptions.propagate((Throwable)new IllegalStateException("Unable to resolve " + (optionalSupertype != null ? String.valueOf(optionalSupertype.getSimpleName()) + " " : "") + "type '" + typeName + "'", e));
        }
    }

    protected <T extends Entity> void decorateSpec(EntitySpec<T> spec) {
        spec.policySpecs(this.extractPolicySpecs());
        spec.enricherSpecs(this.extractEnricherSpecs());
        this.configureEntityConfig(spec);
    }

    protected <T extends Entity> T newEntity(EntitySpec<T> spec) {
        String planId;
        Class entityImpl = spec.getImplementation() != null ? spec.getImplementation() : this.mgmt.getEntityManager().getEntityTypeRegistry().getImplementedBy(spec.getType());
        InternalEntityFactory entityFactory = ((ManagementContextInternal)this.mgmt).getEntityFactory();
        Entity entity = entityFactory.constructEntity(entityImpl, spec);
        if (entity instanceof AbstractApplication) {
            FlagUtils.setFieldsFromFlags((Map)ImmutableMap.of((Object)"mgmt", (Object)this.mgmt), (Object)entity);
        }
        if (spec.getId() != null) {
            FlagUtils.setFieldsFromFlags((Map)ImmutableMap.of((Object)"id", (Object)spec.getId()), (Object)entity);
        }
        if ((planId = (String)spec.getConfig().get(BrooklynCampConstants.PLAN_ID.getConfigKey())) != null) {
            ((EntityInternal)entity).setConfig(BrooklynCampConstants.PLAN_ID, (Object)planId);
        }
        ((ManagementContextInternal)this.mgmt).prePreManage(entity);
        ((AbstractEntity)entity).setManagementContext((ManagementContextInternal)this.mgmt);
        ((AbstractEntity)entity).setProxy(entityFactory.createEntityProxy(spec, entity));
        if (spec.getParent() != null) {
            entity.setParent(spec.getParent());
        }
        return (T)entity;
    }

    private void configureEntityConfig(EntitySpec<?> spec) {
        Object transformed;
        ConfigBag bag = ConfigBag.newInstance((Map)((Map)this.attrs.getStringKey("brooklyn.config")));
        List records = FlagUtils.findAllFlagsAndConfigKeys(null, (Class)spec.getType(), (ConfigBag)bag);
        LinkedHashSet<String> keyNamesUsed = new LinkedHashSet<String>();
        for (FlagUtils.FlagConfigKeyAndValueRecord r : records) {
            if (r.getFlagMaybeValue().isPresent()) {
                transformed = this.transformSpecialFlags(r.getFlagMaybeValue().get(), this.mgmt);
                spec.configure((CharSequence)r.getFlagName(), transformed);
                keyNamesUsed.add(r.getFlagName());
            }
            if (!r.getConfigKeyMaybeValue().isPresent()) continue;
            transformed = this.transformSpecialFlags(r.getConfigKeyMaybeValue().get(), this.mgmt);
            spec.configure(r.getConfigKey(), transformed);
            keyNamesUsed.add(r.getConfigKey().getName());
        }
        for (String key : MutableSet.copyOf(bag.getUnusedConfig().keySet())) {
            if (keyNamesUsed.contains(key)) continue;
            transformed = this.transformSpecialFlags(bag.getStringKey(key), this.mgmt);
            spec.configure(ConfigKeys.newConfigKey(Object.class, (String)key.toString()), transformed);
        }
    }

    protected Object transformSpecialFlags(Object flag, ManagementContext mgmt) {
        if (flag instanceof EntitySpecConfiguration) {
            EntitySpecConfiguration specConfig = (EntitySpecConfiguration)flag;
            Map<String, Object> resolvedConfig = this.transformSpecialFlags(specConfig.getSpecConfiguration(), mgmt);
            specConfig.setSpecConfiguration(resolvedConfig);
            return Factory.newInstance(mgmt, specConfig.getSpecConfiguration()).resolveSpec();
        }
        return flag;
    }

    protected Map<?, ?> transformSpecialFlags(Map<?, ?> flag, final ManagementContext mgmt) {
        return Maps.transformValues(flag, (Function)new Function<Object, Object>(){

            public Object apply(Object input) {
                if (input instanceof Map) {
                    return BrooklynComponentTemplateResolver.this.transformSpecialFlags((Map)input, mgmt);
                }
                if (input instanceof Set) {
                    return MutableSet.of(BrooklynComponentTemplateResolver.this.transformSpecialFlags((Iterable)input, mgmt));
                }
                if (input instanceof List) {
                    return MutableList.copyOf(BrooklynComponentTemplateResolver.this.transformSpecialFlags((Iterable)input, mgmt));
                }
                if (input instanceof Iterable) {
                    return BrooklynComponentTemplateResolver.this.transformSpecialFlags((Iterable)input, mgmt);
                }
                return BrooklynComponentTemplateResolver.this.transformSpecialFlags(input, mgmt);
            }
        });
    }

    protected Iterable<?> transformSpecialFlags(Iterable<?> flag, final ManagementContext mgmt) {
        return Iterables.transform(flag, (Function)new Function<Object, Object>(){

            public Object apply(Object input) {
                if (input instanceof Map) {
                    return BrooklynComponentTemplateResolver.this.transformSpecialFlags((Map)input, mgmt);
                }
                if (input instanceof Set) {
                    return MutableSet.of(BrooklynComponentTemplateResolver.this.transformSpecialFlags((Iterable)input, mgmt));
                }
                if (input instanceof List) {
                    return MutableList.copyOf(BrooklynComponentTemplateResolver.this.transformSpecialFlags((Iterable)input, mgmt));
                }
                if (input instanceof Iterable) {
                    return BrooklynComponentTemplateResolver.this.transformSpecialFlags((Iterable)input, mgmt);
                }
                return BrooklynComponentTemplateResolver.this.transformSpecialFlags(input, mgmt);
            }
        });
    }

    public List<Map<String, Object>> getChildren(Map<String, Object> attrs) {
        if (attrs == null) {
            return null;
        }
        return (List)attrs.get("brooklyn.children");
    }

    private <T extends Policy> PolicySpec<?> toCorePolicySpec(Class<T> clazz, Map<?, ?> config) {
        LinkedHashMap policyConfig = config == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap(config);
        PolicySpec result = PolicySpec.create(clazz).configure((Map)policyConfig);
        return result;
    }

    private <T extends Enricher> EnricherSpec<?> toCoreEnricherSpec(Class<T> clazz, Map<?, ?> config) {
        LinkedHashMap enricherConfig = config == null ? Maps.newLinkedHashMap() : Maps.newLinkedHashMap(config);
        EnricherSpec result = EnricherSpec.create(clazz).configure((Map)enricherConfig);
        return result;
    }

    private List<PolicySpec<?>> extractPolicySpecs() {
        return this.resolvePolicySpecs(this.attrs.getStringKey("brooklyn.policies"));
    }

    private List<PolicySpec<?>> resolvePolicySpecs(Object policies) {
        ArrayList policySpecs = new ArrayList();
        if (policies instanceof Iterable) {
            for (Object policy : (Iterable)policies) {
                if (policy instanceof Map) {
                    String policyTypeName = ((Map)policy).get("policyType").toString();
                    Class<Policy> policyType = this.loadClass(Policy.class, policyTypeName);
                    policySpecs.add(this.toCorePolicySpec(policyType, (Map)((Map)policy).get("brooklyn.config")));
                    continue;
                }
                throw new IllegalArgumentException("policy should be map, not " + policy.getClass());
            }
        } else if (policies != null) {
            throw new IllegalArgumentException("policies body should be iterable, not " + policies.getClass());
        }
        return policySpecs;
    }

    private List<EnricherSpec<?>> extractEnricherSpecs() {
        return this.resolveEnricherSpecs(this.attrs.getStringKey("brooklyn.enrichers"));
    }

    private List<EnricherSpec<?>> resolveEnricherSpecs(Object enrichers) {
        ArrayList enricherSpecs = Lists.newArrayList();
        if (enrichers instanceof Iterable) {
            for (Object enricher : (Iterable)enrichers) {
                if (enricher instanceof Map) {
                    String enricherTypeName = ((Map)enricher).get("enricherType").toString();
                    Class<Enricher> enricherType = this.loadClass(Enricher.class, enricherTypeName);
                    enricherSpecs.add(this.toCoreEnricherSpec(enricherType, (Map)((Map)enricher).get("brooklyn.config")));
                    continue;
                }
                throw new IllegalArgumentException("enricher should be map, not " + enricher.getClass());
            }
        } else if (enrichers != null) {
            throw new IllegalArgumentException("enrichers body should be iterable, not " + enrichers.getClass());
        }
        return enricherSpecs;
    }

    public static class Factory {
        private static Class<? extends BrooklynComponentTemplateResolver> computeResolverType(String knownServiceType, AbstractResource optionalTemplate, ConfigBag attrs) {
            String type = Factory.getDeclaredType(knownServiceType, optionalTemplate, attrs);
            if (type != null) {
                if (type.startsWith("brooklyn:") || type.startsWith("java:")) {
                    return BrooklynComponentTemplateResolver.class;
                }
                if (type.equalsIgnoreCase("chef") || type.startsWith("chef:")) {
                    return ChefComponentTemplateResolver.class;
                }
            }
            return null;
        }

        public static BrooklynComponentTemplateResolver newInstance(ManagementContext mgmt, Map<String, Object> childAttrs) {
            return Factory.newInstance(mgmt, ConfigBag.newInstance(childAttrs), null);
        }

        public static BrooklynComponentTemplateResolver newInstance(ManagementContext mgmt, AbstractResource template) {
            return Factory.newInstance(mgmt, ConfigBag.newInstance((Map)template.getCustomAttributes()), template);
        }

        public static BrooklynComponentTemplateResolver newInstance(ManagementContext mgmt, String serviceType) {
            return Factory.newInstance(mgmt, ConfigBag.newInstance().configureStringKey("serviceType", (Object)serviceType), null);
        }

        private static BrooklynComponentTemplateResolver newInstance(ManagementContext mgmt, ConfigBag attrs, AbstractResource optionalTemplate) {
            Class<? extends BrooklynComponentTemplateResolver> rt = Factory.computeResolverType(null, optionalTemplate, attrs);
            if (rt == null) {
                rt = BrooklynComponentTemplateResolver.class;
            }
            try {
                return (BrooklynComponentTemplateResolver)rt.getConstructors()[0].newInstance(mgmt, attrs, optionalTemplate);
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
        }

        private static String getDeclaredType(String knownServiceType, AbstractResource optionalTemplate, ConfigBag attrs) {
            String type = knownServiceType;
            if (type == null && optionalTemplate != null && ((type = optionalTemplate.getType()).equals("AssemblyTemplate") || type.equals("PlatformComponentTemplate") || type.equals("ApplicationComponentTemplate"))) {
                type = null;
            }
            if (type == null) {
                type = Factory.extractServiceTypeAttribute(attrs);
            }
            return type;
        }

        private static String extractServiceTypeAttribute(ConfigBag attrs) {
            String type = (String)attrs.getStringKey("serviceType");
            if (type == null) {
                type = (String)attrs.getStringKey("service_type");
            }
            if (type == null) {
                type = (String)attrs.getStringKey("type");
            }
            return type;
        }

        public static boolean supportsType(ManagementContext mgmt, String serviceType) {
            Class<? extends BrooklynComponentTemplateResolver> type = Factory.computeResolverType(serviceType, null, null);
            if (type != null) {
                return true;
            }
            try {
                Factory.newInstance(mgmt, serviceType).loadEntityClass();
                return true;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                return false;
            }
        }
    }
}

