/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.entity.Entity;
import brooklyn.management.ManagementContext;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynEntityClassResolver {
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynEntityClassResolver.class);

    public static <T extends Entity> Class<T> resolveEntity(String entityTypeName, ManagementContext mgmt) {
        Preconditions.checkNotNull((Object)mgmt, (Object)"management context");
        Maybe<Class<T>> entityClazz = BrooklynEntityClassResolver.tryLoadEntityFromCatalogue(entityTypeName, mgmt);
        if (!entityClazz.isPresent()) {
            entityClazz = BrooklynEntityClassResolver.tryLoadFromClasspath(entityTypeName, mgmt);
        }
        if (!entityClazz.isPresent()) {
            LOG.warn("No catalog item for {} and could not load class directly; throwing", (Object)entityTypeName);
            throw new IllegalStateException("Unable to load class " + entityTypeName + " (extending Entity) from catalogue or classpath: not found");
        }
        if (!Entity.class.isAssignableFrom((Class)entityClazz.get())) {
            LOG.warn("Found class {} on classpath but it is not assignable to {}", (Object)entityTypeName, Entity.class);
            throw new IllegalStateException("Unable to load class " + entityTypeName + " (extending Entity) from catalogue or classpath: wrong type " + entityClazz.get());
        }
        return (Class)entityClazz.get();
    }

    public static <T extends Entity> Maybe<Class<T>> tryLoadEntityFromCatalogue(String entityTypeName, ManagementContext mgmt) {
        try {
            return Maybe.of((Object)mgmt.getCatalog().loadClassByType(entityTypeName, Entity.class));
        }
        catch (NoSuchElementException noSuchElementException) {
            LOG.debug("Class {} not found in catalogue classpath", (Object)entityTypeName);
            return Maybe.absent();
        }
    }

    public static <T> Maybe<Class<T>> tryLoadFromClasspath(String typeName, ManagementContext mgmt) {
        Class<?> clazz;
        try {
            clazz = mgmt.getCatalog().getRootClassLoader().loadClass(typeName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.debug("Class {} not found on classpath", (Object)typeName);
            return Maybe.absent((Throwable)new Throwable("Could not find " + typeName + " on classpath"));
        }
        return Maybe.of(clazz);
    }
}

