/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.creation;

import brooklyn.management.ManagementContext;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.text.Strings;
import com.google.common.collect.Lists;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynAssemblyTemplateInstantiator;
import io.brooklyn.camp.brooklyn.spi.creation.BrooklynComponentTemplateResolver;
import io.brooklyn.camp.spi.PlatformComponentTemplate;
import io.brooklyn.camp.spi.pdp.AssemblyTemplateConstructor;
import io.brooklyn.camp.spi.pdp.Service;
import io.brooklyn.camp.spi.resolve.PdpMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynEntityMatcher
implements PdpMatcher {
    private static final Logger log = LoggerFactory.getLogger(BrooklynEntityMatcher.class);
    protected final ManagementContext mgmt;

    public BrooklynEntityMatcher(ManagementContext bmc) {
        this.mgmt = bmc;
    }

    public boolean accepts(Object deploymentPlanItem) {
        return this.lookupType(deploymentPlanItem) != null;
    }

    protected String lookupType(Object deploymentPlanItem) {
        if (deploymentPlanItem instanceof Service) {
            if (!BrooklynComponentTemplateResolver.Factory.supportsType(this.mgmt, ((Service)deploymentPlanItem).getServiceType())) {
                return null;
            }
            return ((Service)deploymentPlanItem).getServiceType();
        }
        return null;
    }

    public boolean apply(Object deploymentPlanItem, AssemblyTemplateConstructor atc) {
        List<FlagUtils.FlagConfigKeyAndValueRecord> topLevelApparentConfig;
        Object locations;
        Object location;
        MutableMap attrs;
        if (!(deploymentPlanItem instanceof Service)) {
            return false;
        }
        String type = this.lookupType(deploymentPlanItem);
        if (type == null) {
            return false;
        }
        log.debug("Item " + deploymentPlanItem + " being instantiated with " + type);
        Class old = atc.getInstantiator();
        if (old != null && !old.equals(BrooklynAssemblyTemplateInstantiator.class)) {
            log.warn("Can't mix Brooklyn entities with non-Brooklyn entities (at present): " + old);
            return false;
        }
        PlatformComponentTemplate.Builder builder = PlatformComponentTemplate.builder();
        builder.type(type.indexOf(58) == -1 ? "brooklyn:" + type : type);
        atc.instantiator(BrooklynAssemblyTemplateInstantiator.class);
        String name = ((Service)deploymentPlanItem).getName();
        if (!Strings.isBlank((CharSequence)name)) {
            builder.name(name);
        }
        if ((attrs = MutableMap.copyOf((Map)((Service)deploymentPlanItem).getCustomAttributes())).containsKey("id")) {
            builder.customAttribute("planId", attrs.remove("id"));
        }
        if ((location = attrs.remove("location")) != null) {
            builder.customAttribute("location", location);
        }
        if ((locations = attrs.remove("locations")) != null) {
            builder.customAttribute("locations", locations);
        }
        MutableMap brooklynConfig = MutableMap.of();
        Object origBrooklynConfig = attrs.remove("brooklyn.config");
        if (origBrooklynConfig != null) {
            if (!(origBrooklynConfig instanceof Map)) {
                throw new IllegalArgumentException("brooklyn.config must be a map of brooklyn config keys");
            }
            brooklynConfig.putAll((Map)origBrooklynConfig);
        }
        if ((topLevelApparentConfig = this.extractValidConfigFlagsOrKeys(type, (Map<String, Object>)attrs, true)) != null) {
            for (FlagUtils.FlagConfigKeyAndValueRecord r : topLevelApparentConfig) {
                if (r.getConfigKeyMaybeValue().isPresent()) {
                    brooklynConfig.put((Object)r.getConfigKey(), r.getConfigKeyMaybeValue().get());
                }
                if (!r.getFlagMaybeValue().isPresent()) continue;
                brooklynConfig.put((Object)r.getFlagName(), r.getFlagMaybeValue().get());
            }
        }
        if (!brooklynConfig.isEmpty()) {
            builder.customAttribute("brooklyn.config", (Object)brooklynConfig);
        }
        ArrayList brooklynPolicies = Lists.newArrayList();
        Object origBrooklynPolicies = attrs.remove("brooklyn.policies");
        if (origBrooklynPolicies != null) {
            if (!(origBrooklynPolicies instanceof List)) {
                throw new IllegalArgumentException("brooklyn.policies must be a list of brooklyn policy definitions");
            }
            brooklynPolicies.addAll((List)origBrooklynPolicies);
        }
        if (!brooklynPolicies.isEmpty()) {
            builder.customAttribute("brooklyn.policies", (Object)brooklynPolicies);
        }
        ArrayList brooklynEnrichers = Lists.newArrayList();
        Object origBrooklynEnrichers = attrs.remove("brooklyn.enrichers");
        if (origBrooklynEnrichers != null) {
            if (!(origBrooklynEnrichers instanceof List)) {
                throw new IllegalArgumentException("brooklyn.enrichers must be a list of brooklyn enricher definitions");
            }
            brooklynEnrichers.addAll((List)origBrooklynEnrichers);
        }
        if (!brooklynEnrichers.isEmpty()) {
            builder.customAttribute("brooklyn.enrichers", (Object)brooklynEnrichers);
        }
        ArrayList brooklynChildren = Lists.newArrayList();
        Object origBrooklynChildren = attrs.remove("brooklyn.children");
        if (origBrooklynChildren != null) {
            if (!(origBrooklynChildren instanceof List)) {
                throw new IllegalArgumentException("brooklyn.children must be a list of brooklyn entity definitions");
            }
            brooklynChildren.addAll((List)origBrooklynChildren);
        }
        if (!brooklynChildren.isEmpty()) {
            builder.customAttribute("brooklyn.children", (Object)brooklynChildren);
        }
        if (!attrs.isEmpty()) {
            log.warn("Ignoring PDP attributes on " + deploymentPlanItem + ": " + attrs);
        }
        atc.add((PlatformComponentTemplate)builder.build());
        return true;
    }

    protected List<FlagUtils.FlagConfigKeyAndValueRecord> extractValidConfigFlagsOrKeys(String typeName, Map<String, Object> attrs, boolean removeIfFound) {
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        try {
            Class type = BrooklynComponentTemplateResolver.Factory.newInstance(this.mgmt, typeName).loadEntityClass();
            ConfigBag bag = ConfigBag.newInstance(attrs);
            List values = FlagUtils.findAllFlagsAndConfigKeys(null, type, (ConfigBag)bag);
            if (removeIfFound) {
                MutableMap used = MutableMap.copyOf((Map)bag.getAllConfig());
                for (String unusedKey : bag.getUnusedConfig().keySet()) {
                    used.remove((Object)unusedKey);
                }
                for (String usedKey : used.keySet()) {
                    attrs.remove(usedKey);
                }
            }
            return values;
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            log.warn("Ignoring configuration attributes on " + typeName + " due to " + e, (Throwable)e);
            return null;
        }
    }
}

