/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.dsl;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.effector.EffectorTasks;
import brooklyn.management.Task;
import brooklyn.management.TaskFactory;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.DeferredSupplier;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslInterpreter;
import io.brooklyn.camp.spi.resolve.interpret.PlanInterpretationNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BrooklynDslDeferredSupplier<T>
implements DeferredSupplier<T>,
TaskFactory<Task<T>> {
    private static final Logger log = LoggerFactory.getLogger(BrooklynDslDeferredSupplier.class);
    @JsonInclude
    @JsonProperty(value="$brooklyn:literal")
    public final Object dsl;

    public BrooklynDslDeferredSupplier() {
        PlanInterpretationNode sourceNode = BrooklynDslInterpreter.currentNode();
        this.dsl = sourceNode != null ? sourceNode.getOriginalValue() : null;
    }

    protected final EntityInternal entity() {
        return (EntityInternal)EffectorTasks.findEntity();
    }

    public final synchronized T get() {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Queuing task to resolve " + this.dsl);
            }
            Object result = ((Task)Entities.submit((Entity)this.entity(), this.newTask())).get();
            if (log.isDebugEnabled()) {
                log.debug("Resolved " + result + " from " + this.dsl);
            }
            return (T)result;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public abstract Task<T> newTask();
}

