/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.dsl.methods;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityDynamicType;
import brooklyn.event.Sensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.management.Task;
import brooklyn.util.exceptions.Exceptions;
import io.brooklyn.camp.brooklyn.spi.creation.EntitySpecConfiguration;
import io.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import io.brooklyn.camp.brooklyn.spi.dsl.DslUtils;
import io.brooklyn.camp.brooklyn.spi.dsl.methods.DslComponent;
import java.util.Map;

public class BrooklynDslCommon {
    public static Object literal(Object expression) {
        return expression;
    }

    public static DslComponent component(String id) {
        return BrooklynDslCommon.component("global", id);
    }

    public static DslComponent component(String scope, String id) {
        if (!DslComponent.Scope.isValid(scope)) {
            throw new IllegalArgumentException(String.valueOf(scope) + " is not a vlaid scope");
        }
        return new DslComponent(DslComponent.Scope.fromString(scope), id);
    }

    public static Object formatString(final String pattern, final Object ... args) {
        if (DslUtils.resolved(args)) {
            return String.format(pattern, args);
        }
        return new BrooklynDslDeferredSupplier<String>(){

            @Override
            public Task<String> newTask() {
                return DependentConfiguration.formatString((String)pattern, (Object[])args);
            }
        };
    }

    public static Object sensor(String clazzName, String sensorName) {
        try {
            Class<?> clazz = Class.forName(clazzName);
            if (!Entity.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Class " + clazzName + " is not an Entity");
            }
            Sensor sensor = new EntityDynamicType(clazz).getSensor(sensorName);
            if (sensor == null) {
                throw new IllegalArgumentException("Sensor " + sensorName + " not found on class " + clazzName);
            }
            return sensor;
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static EntitySpecConfiguration entitySpec(Map<String, Object> arguments) {
        return new EntitySpecConfiguration(arguments);
    }
}

