/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.brooklyn.spi.dsl.methods;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityPredicates;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.event.basic.Sensors;
import brooklyn.management.Task;
import brooklyn.management.internal.EntityManagerInternal;
import brooklyn.util.task.TaskBuilder;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import io.brooklyn.camp.brooklyn.BrooklynCampConstants;
import io.brooklyn.camp.brooklyn.spi.dsl.BrooklynDslDeferredSupplier;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;

public class DslComponent
extends BrooklynDslDeferredSupplier<Entity> {
    private final String componentId;
    private final Scope scope;

    public DslComponent(String componentId) {
        this(Scope.GLOBAL, componentId);
    }

    public DslComponent(Scope scope, String componentId) {
        Preconditions.checkNotNull((Object)((Object)scope), (Object)"scope");
        this.componentId = componentId;
        this.scope = scope;
    }

    @Override
    public Task<Entity> newTask() {
        return TaskBuilder.builder().name("component(" + this.componentId + ")").body((Callable)new Callable<Entity>(){

            @Override
            public Entity call() throws Exception {
                Iterable entitiesToSearch = null;
                switch (DslComponent.this.scope) {
                    case THIS: {
                        return DslComponent.this.entity();
                    }
                    case PARENT: {
                        return DslComponent.this.entity().getParent();
                    }
                    case GLOBAL: {
                        entitiesToSearch = ((EntityManagerInternal)DslComponent.this.entity().getManagementContext().getEntityManager()).getAllEntitiesInApplication(DslComponent.this.entity().getApplication());
                        break;
                    }
                    case DESCENDANT: {
                        entitiesToSearch = Sets.newLinkedHashSet();
                        DslComponent.this.addDescendants((Entity)DslComponent.this.entity(), entitiesToSearch);
                        break;
                    }
                    case SIBLING: {
                        entitiesToSearch = DslComponent.this.entity().getParent().getChildren();
                        break;
                    }
                    case CHILD: {
                        entitiesToSearch = DslComponent.this.entity().getChildren();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected scope " + (Object)((Object)DslComponent.this.scope));
                    }
                }
                Optional result = Iterables.tryFind((Iterable)entitiesToSearch, (Predicate)EntityPredicates.configEqualTo(BrooklynCampConstants.PLAN_ID, (Object)DslComponent.this.componentId));
                if (result.isPresent()) {
                    return (Entity)result.get();
                }
                throw new NoSuchElementException("No entity matching id " + DslComponent.this.componentId);
            }
        }).build();
    }

    private void addDescendants(Entity entity, Set<Entity> entities) {
        entities.add(entity);
        for (Entity child : entity.getChildren()) {
            this.addDescendants(child, entities);
        }
    }

    public BrooklynDslDeferredSupplier<?> attributeWhenReady(final String sensorName) {
        return new BrooklynDslDeferredSupplier<Object>(){

            @Override
            public Task<Object> newTask() {
                Entity targetEntity = (Entity)DslComponent.this.get();
                Sensor targetSensor = targetEntity.getEntityType().getSensor(sensorName);
                if (!(targetSensor instanceof AttributeSensor)) {
                    targetSensor = Sensors.newSensor(Object.class, (String)sensorName);
                }
                return DependentConfiguration.attributeWhenReady((Entity)targetEntity, (AttributeSensor)((AttributeSensor)targetSensor));
            }
        };
    }

    public static enum Scope {
        GLOBAL("global"),
        CHILD("child"),
        PARENT("parent"),
        SIBLING("sibling"),
        DESCENDANT("descendant"),
        THIS("this");

        public static final Set<Scope> VALUES;
        private final String name;

        static {
            VALUES = ImmutableSet.of((Object)((Object)GLOBAL), (Object)((Object)CHILD), (Object)((Object)PARENT), (Object)((Object)SIBLING), (Object)((Object)DESCENDANT), (Object)((Object)THIS), (Object[])new Scope[0]);
        }

        private Scope(String name) {
            this.name = name;
        }

        public static Scope fromString(String name) {
            for (Scope scope : VALUES) {
                if (!scope.name.toLowerCase().equals(name.toLowerCase())) continue;
                return scope;
            }
            throw new IllegalArgumentException(String.valueOf(name) + " is not a valid scope");
        }

        public static boolean isValid(String name) {
            for (Scope scope : VALUES) {
                if (!scope.name.toLowerCase().equals(name.toLowerCase())) continue;
                return true;
            }
            return false;
        }
    }
}

