/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.security.CodeSigner;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.openjdk.btrace.agent.Client;
import org.openjdk.btrace.agent.ClientContext;
import org.openjdk.btrace.core.comm.Command;
import org.openjdk.btrace.core.comm.ExitCommand;
import org.openjdk.btrace.core.comm.InstrumentCommand;
import org.openjdk.btrace.core.comm.PrintableCommand;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

class FileClient
extends Client {
    private static final Logger log = LoggerFactory.getLogger(FileClient.class);
    private final AtomicBoolean noOutputNotified = new AtomicBoolean(false);
    private boolean canLoadPack = true;

    FileClient(ClientContext ctx, File scriptFile) throws IOException {
        super(ctx);
        if (!this.init(this.readScript(scriptFile))) {
            log.warn("Unable to load BTrace script {}", (Object)scriptFile);
        }
    }

    private static byte[] readAll(InputStream is, long size) throws IOException {
        int read;
        if (is == null) {
            throw new NullPointerException();
        }
        byte[] buf = new byte[size != -1L ? Math.min((int)size, 0x20000000) : 8192];
        int bufsize = buf.length;
        int off = 0;
        while ((read = is.read(buf, off, bufsize - off)) > -1) {
            if ((off += read) < bufsize) continue;
            buf = Arrays.copyOf(buf, bufsize * 2);
            bufsize = buf.length;
        }
        return Arrays.copyOf(buf, off);
    }

    private boolean init(byte[] code) throws IOException {
        boolean ret;
        InstrumentCommand cmd = new InstrumentCommand(code, this.argsMap);
        boolean bl = ret = this.loadClass(cmd) != null;
        if (ret) {
            this.initialize();
        }
        return ret;
    }

    public void onCommand(Command cmd) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("client {}: got {}", (Object)this.getClassName(), (Object)cmd);
        }
        switch (cmd.getType()) {
            case 2: {
                this.onExit(((ExitCommand)cmd).getExitCode());
                break;
            }
            default: {
                if (!(cmd instanceof PrintableCommand)) break;
                if (this.out == null) {
                    if (!this.noOutputNotified.compareAndSet(false, true)) break;
                    log.debug("No output stream. DataCommand output is ignored.");
                    break;
                }
                ((PrintableCommand)cmd).print(this.out);
            }
        }
    }

    private byte[] readScript(File file) throws IOException {
        String path = file.getPath();
        if (path.startsWith("META-INF/btrace/")) {
            return this.settings.isTrusted() ? this.loadQuick(path) : this.loadWithSecurity(path);
        }
        int size = (int)file.length();
        try (FileInputStream fis = new FileInputStream(file);){
            byte[] byArray = FileClient.readAll(fis, size);
            return byArray;
        }
    }

    private byte[] loadQuick(String path) throws IOException {
        try (InputStream is = ClassLoader.getSystemResourceAsStream(path);){
            byte[] byArray = FileClient.readAll(is, -1L);
            return byArray;
        }
    }

    private byte[] loadWithSecurity(String path) throws IOException {
        URL scriptUrl = ClassLoader.getSystemResource(path);
        if (scriptUrl.getProtocol().equals("jar")) {
            String jarPath = scriptUrl.getPath().substring(5, scriptUrl.getPath().indexOf("!"));
            JarFile jar = new JarFile(URLDecoder.decode(jarPath, "UTF-8"));
            Enumeration<JarEntry> ens = jar.entries();
            while (ens.hasMoreElements()) {
                JarEntry en = ens.nextElement();
                if (en.isDirectory() || !en.toString().equals(path)) continue;
                byte[] data = FileClient.readAll(jar.getInputStream(en), en.getSize());
                CodeSigner[] signers = en.getCodeSigners();
                this.canLoadPack = signers != null && signers.length != 0;
                return data;
            }
        }
        return null;
    }
}

