/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import org.openjdk.btrace.instr.Level;
import org.openjdk.btrace.instr.MethodInstrumentorHelper;
import org.openjdk.btrace.libs.org.objectweb.asm.Handle;
import org.openjdk.btrace.libs.org.objectweb.asm.Label;
import org.openjdk.btrace.libs.org.objectweb.asm.MethodVisitor;
import org.openjdk.btrace.libs.org.objectweb.asm.Type;
import org.openjdk.btrace.runtime.Interval;

public final class Assembler {
    private final MethodVisitor mv;
    private final MethodInstrumentorHelper mHelper;

    public Assembler(MethodVisitor mv, MethodInstrumentorHelper mHelper) {
        this.mv = mv;
        this.mHelper = mHelper;
    }

    public Assembler push(int value) {
        if (value >= -1 && value <= 5) {
            this.mv.visitInsn(3 + value);
        } else if (value >= -128 && value <= 127) {
            this.mv.visitIntInsn(16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            this.mv.visitIntInsn(17, value);
        } else {
            this.mv.visitLdcInsn((Object)value);
        }
        return this;
    }

    public Assembler arrayLoad(Type type) {
        this.mv.visitInsn(type.getOpcode(46));
        return this;
    }

    public Assembler arrayStore(Type type) {
        this.mv.visitInsn(type.getOpcode(79));
        return this;
    }

    public Assembler jump(int opcode, Label l) {
        this.mv.visitJumpInsn(opcode, l);
        return this;
    }

    public Assembler ldc(Object o) {
        long l;
        int i;
        if (o == null) {
            return this.loadNull();
        }
        if (o instanceof Integer && (i = ((Integer)o).intValue()) >= -1 && i <= 5) {
            int opcode = -1;
            switch (i) {
                case 0: {
                    opcode = 3;
                    break;
                }
                case 1: {
                    opcode = 4;
                    break;
                }
                case 2: {
                    opcode = 5;
                    break;
                }
                case 3: {
                    opcode = 6;
                    break;
                }
                case 4: {
                    opcode = 7;
                    break;
                }
                case 5: {
                    opcode = 8;
                    break;
                }
                case -1: {
                    opcode = 2;
                }
            }
            this.mv.visitInsn(opcode);
            return this;
        }
        if (o instanceof Long && (l = ((Long)o).longValue()) >= 0L && l <= 1L) {
            int opcode = -1;
            switch ((int)l) {
                case 0: {
                    opcode = 9;
                    break;
                }
                case 1: {
                    opcode = 10;
                }
            }
            this.mv.visitInsn(opcode);
            return this;
        }
        this.mv.visitLdcInsn(o);
        return this;
    }

    public Assembler sub(Type t) {
        int opcode = -1;
        switch (t.getSort()) {
            case 3: 
            case 4: 
            case 5: {
                opcode = 100;
                break;
            }
            case 7: {
                opcode = 101;
                break;
            }
            case 6: {
                opcode = 102;
                break;
            }
            case 8: {
                opcode = 103;
            }
        }
        if (opcode != -1) {
            this.mv.visitInsn(opcode);
        }
        return this;
    }

    public Assembler loadNull() {
        this.mv.visitInsn(1);
        return this;
    }

    public Assembler loadLocal(Type type, int index) {
        this.mv.visitVarInsn(type.getOpcode(21), index);
        return this;
    }

    public Assembler storeLocal(Type type, int index) {
        this.mv.visitVarInsn(type.getOpcode(54), index);
        return this;
    }

    public Assembler storeField(Type owner, String name, Type t) {
        this.mv.visitFieldInsn(181, owner.getInternalName(), name, t.getDescriptor());
        return this;
    }

    public Assembler storeStaticField(Type owner, String name, Type t) {
        this.mv.visitFieldInsn(179, owner.getInternalName(), name, t.getDescriptor());
        return this;
    }

    public Assembler loadField(Type owner, String name, Type t) {
        this.mv.visitFieldInsn(180, owner.getInternalName(), name, t.getDescriptor());
        return this;
    }

    public Assembler loadStaticField(Type owner, String name, Type t) {
        this.mv.visitFieldInsn(178, owner.getInternalName(), name, t.getDescriptor());
        return this;
    }

    public Assembler pop() {
        this.mv.visitInsn(87);
        return this;
    }

    public Assembler dup() {
        this.mv.visitInsn(89);
        return this;
    }

    public Assembler dup_x1() {
        this.mv.visitInsn(90);
        return this;
    }

    public Assembler dup_x2() {
        this.mv.visitInsn(91);
        return this;
    }

    public Assembler dup2() {
        this.mv.visitInsn(92);
        return this;
    }

    public Assembler dup2_x1() {
        this.mv.visitInsn(93);
        return this;
    }

    public Assembler dup2_x2() {
        this.mv.visitInsn(94);
        return this;
    }

    public Assembler swap() {
        this.mv.visitInsn(95);
        return this;
    }

    public Assembler newInstance(Type t) {
        this.mv.visitTypeInsn(187, t.getInternalName());
        return this;
    }

    public Assembler newArray(Type t) {
        this.mv.visitTypeInsn(189, t.getInternalName());
        return this;
    }

    public Assembler dupArrayValue(int arrayOpcode) {
        switch (arrayOpcode) {
            case 46: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 79: 
            case 81: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.dup();
                break;
            }
            case 47: 
            case 49: 
            case 80: 
            case 82: {
                this.dup2();
            }
        }
        return this;
    }

    public Assembler dupReturnValue(int returnOpcode) {
        switch (returnOpcode) {
            case 172: 
            case 174: 
            case 176: {
                this.mv.visitInsn(89);
                break;
            }
            case 173: 
            case 175: {
                this.mv.visitInsn(92);
                break;
            }
            case 177: {
                break;
            }
            default: {
                throw new IllegalArgumentException("not return");
            }
        }
        return this;
    }

    public Assembler dupValue(Type type) {
        switch (type.getSize()) {
            case 1: {
                this.dup();
                break;
            }
            case 2: {
                this.dup2();
            }
        }
        return this;
    }

    public Assembler dupValue(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                this.mv.visitInsn(89);
                break;
            }
            case 'D': 
            case 'J': {
                this.mv.visitInsn(92);
                break;
            }
            default: {
                throw new RuntimeException("invalid signature");
            }
        }
        return this;
    }

    public Assembler box(Type type) {
        return this.box(type.getDescriptor());
    }

    public Assembler box(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                break;
            }
            case 'Z': {
                this.invokeStatic("java/lang/Boolean", "valueOf", "(Z)Ljava/lang/Boolean;");
                break;
            }
            case 'C': {
                this.invokeStatic("java/lang/Character", "valueOf", "(C)Ljava/lang/Character;");
                break;
            }
            case 'B': {
                this.invokeStatic("java/lang/Byte", "valueOf", "(B)Ljava/lang/Byte;");
                break;
            }
            case 'S': {
                this.invokeStatic("java/lang/Short", "valueOf", "(S)Ljava/lang/Short;");
                break;
            }
            case 'I': {
                this.invokeStatic("java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
                break;
            }
            case 'J': {
                this.invokeStatic("java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
                break;
            }
            case 'F': {
                this.invokeStatic("java/lang/Float", "valueOf", "(F)Ljava/lang/Float;");
                break;
            }
            case 'D': {
                this.invokeStatic("java/lang/Double", "valueOf", "(D)Ljava/lang/Double;");
            }
        }
        return this;
    }

    public Assembler unbox(Type type) {
        return this.unbox(type.getDescriptor());
    }

    public Assembler unbox(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                this.mv.visitTypeInsn(192, Type.getType((String)desc).getInternalName());
                break;
            }
            case 'Z': {
                this.mv.visitTypeInsn(192, "java/lang/Boolean");
                this.invokeVirtual("java/lang/Boolean", "booleanValue", "()Z");
                break;
            }
            case 'C': {
                this.mv.visitTypeInsn(192, "java/lang/Character");
                this.invokeVirtual("java/lang/Character", "charValue", "()C");
                break;
            }
            case 'B': {
                this.mv.visitTypeInsn(192, "java/lang/Number");
                this.invokeVirtual("java/lang/Number", "byteValue", "()B");
                break;
            }
            case 'S': {
                this.mv.visitTypeInsn(192, "java/lang/Number");
                this.invokeVirtual("java/lang/Number", "shortValue", "()S");
                break;
            }
            case 'I': {
                this.mv.visitTypeInsn(192, "java/lang/Number");
                this.invokeVirtual("java/lang/Number", "intValue", "()I");
                break;
            }
            case 'J': {
                this.mv.visitTypeInsn(192, "java/lang/Number");
                this.invokeVirtual("java/lang/Number", "longValue", "()J");
                break;
            }
            case 'F': {
                this.mv.visitTypeInsn(192, "java/lang/Number");
                this.invokeVirtual("java/lang/Number", "floatValue", "()F");
                break;
            }
            case 'D': {
                this.mv.visitTypeInsn(192, "java/lang/Number");
                this.invokeVirtual("java/lang/Number", "doubleValue", "()D");
            }
        }
        return this;
    }

    public Assembler defaultValue(String desc) {
        char typeCode = desc.charAt(0);
        switch (typeCode) {
            case 'L': 
            case '[': {
                this.mv.visitInsn(1);
                break;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                this.mv.visitInsn(3);
                break;
            }
            case 'J': {
                this.mv.visitInsn(9);
                break;
            }
            case 'F': {
                this.mv.visitInsn(11);
                break;
            }
            case 'D': {
                this.mv.visitInsn(14);
            }
        }
        return this;
    }

    public Assembler println(String msg) {
        this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        this.mv.visitLdcInsn((Object)msg);
        this.invokeVirtual("java/io/PrintStream", "println", "(Ljava/lang/String;)V");
        return this;
    }

    public Assembler printObject() {
        this.mv.visitFieldInsn(178, "java/lang/System", "out", "Ljava/io/PrintStream;");
        this.mv.visitInsn(95);
        this.mv.visitMethodInsn(182, "java/io/PrintStream", "println", "(Ljava/lang/Object;)V", false);
        return this;
    }

    public Assembler invokeVirtual(String owner, String method, String desc) {
        this.mv.visitMethodInsn(182, owner, method, desc, false);
        return this;
    }

    public Assembler invokeSpecial(String owner, String method, String desc) {
        this.mv.visitMethodInsn(183, owner, method, desc, false);
        return this;
    }

    public Assembler invokeStatic(String owner, String method, String desc) {
        this.mv.visitMethodInsn(184, owner, method, desc, false);
        return this;
    }

    public Assembler invokeDynamic(String name, String descriptor, Handle bootstrap, Object ... bootstrapArguments) {
        this.mv.visitInvokeDynamicInsn(name, descriptor, bootstrap, bootstrapArguments);
        return this;
    }

    public Assembler invokeInterface(String owner, String method, String desc) {
        this.mv.visitMethodInsn(182, owner, method, desc, true);
        return this;
    }

    public Assembler getStatic(String owner, String name, String desc) {
        this.mv.visitFieldInsn(178, owner, name, desc);
        return this;
    }

    public Assembler putStatic(String owner, String name, String desc) {
        this.mv.visitFieldInsn(179, owner, name, desc);
        return this;
    }

    public Assembler label(Label l) {
        this.mv.visitLabel(l);
        return this;
    }

    public Assembler addLevelCheck(String clsName, Level level, Label jmp) {
        return this.addLevelCheck(clsName, level.getValue(), jmp);
    }

    public Assembler addLevelCheck(String clsName, Interval itv, Label jmp) {
        this.getStatic(clsName, "$btrace$$level", "I");
        if (itv.getA() <= 0) {
            if (itv.getB() != Integer.MAX_VALUE) {
                this.ldc(itv.getB());
                this.jump(163, jmp);
            }
        } else if (itv.getA() < itv.getB()) {
            if (itv.getB() == Integer.MAX_VALUE) {
                this.ldc(itv.getA());
                this.jump(161, jmp);
            } else {
                this.ldc(itv.getA());
                this.jump(161, jmp);
                this.getStatic(clsName, "$btrace$$level", "I");
                this.ldc(itv.getB());
                this.jump(163, jmp);
            }
        }
        return this;
    }

    public Assembler compareLevel(String clsName, Level level) {
        Interval itv = level.getValue();
        if (itv.getA() <= 0) {
            if (itv.getB() != Integer.MAX_VALUE) {
                this.ldc(itv.getB());
                this.getStatic(clsName, "$btrace$$level", "I");
                this.sub(Type.INT_TYPE);
            }
        } else if (itv.getA() < itv.getB()) {
            if (itv.getB() == Integer.MAX_VALUE) {
                this.getStatic(clsName, "$btrace$$level", "I");
                this.ldc(itv.getA());
                this.sub(Type.INT_TYPE);
            } else {
                Label l1 = new Label();
                Label l2 = new Label();
                this.ldc(itv.getA());
                this.jump(161, l1);
                this.getStatic(clsName, "$btrace$$level", "I");
                this.ldc(itv.getB());
                this.jump(163, l1);
                this.ldc(0);
                Label l3 = new Label();
                this.label(l3);
                this.mHelper.insertFrameSameStack(l3);
                this.jump(167, l2);
                this.label(l1);
                this.mHelper.insertFrameSameStack(l1);
                this.ldc(-1);
                this.label(l2);
                this.mHelper.insertFrameSameStack(l2);
            }
        }
        return this;
    }
}

