/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.btrace.instr;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.openjdk.btrace.core.ArgsMap;
import org.openjdk.btrace.core.SharedSettings;
import org.openjdk.btrace.instr.BTraceProbe;
import org.openjdk.btrace.instr.BTraceProbeNode;
import org.openjdk.btrace.instr.BTraceProbePersisted;
import org.openjdk.btrace.instr.HandlerRepositoryImpl;
import org.openjdk.btrace.libs.org.slf4j.Logger;
import org.openjdk.btrace.libs.org.slf4j.LoggerFactory;

public final class BTraceProbeFactory {
    private static final Logger log = LoggerFactory.getLogger(BTraceProbeFactory.class);
    private static final int CLASS_MAGIC = -889275714;
    private final SharedSettings settings;

    public BTraceProbeFactory(SharedSettings settings) {
        this.settings = settings;
    }

    private static void applyArgs(BTraceProbe bp, ArgsMap argsMap) {
        if (bp != null && argsMap != null && !argsMap.isEmpty()) {
            bp.applyArgs(argsMap);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean canLoad(String filePath) {
        if (filePath == null) {
            return false;
        }
        try (DataInputStream dis = new DataInputStream(Files.newInputStream(Paths.get(filePath, new String[0]), new OpenOption[0]));){
            int magic = dis.readInt();
            boolean bl = magic == -889275714 || magic == -1160852790;
            return bl;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    SharedSettings getSettings() {
        return this.settings;
    }

    public BTraceProbe createProbe(byte[] code) {
        return this.createProbe(code, null);
    }

    public BTraceProbe createProbe(byte[] code, ArgsMap argsMap) {
        BTraceProbe bp = null;
        int mgc = (code[0] & 0xFF) << 24 | (code[1] & 0xFF) << 16 | (code[2] & 0xFF) << 8 | code[3] & 0xFF;
        if (mgc == -1160852790) {
            BTraceProbePersisted bpp = new BTraceProbePersisted(this);
            try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(Arrays.copyOfRange(code, 4, code.length)));){
                bpp.read(dis);
                bp = bpp;
            }
            catch (IOException e) {
                log.debug("Failed to read BTrace pack", (Throwable)e);
            }
        } else {
            bp = new BTraceProbeNode(this, code);
        }
        BTraceProbeFactory.applyArgs(bp, argsMap);
        HandlerRepositoryImpl.registerProbe(bp);
        return bp;
    }

    public BTraceProbe createProbe(InputStream code) {
        return this.createProbe(code, null);
    }

    public BTraceProbe createProbe(InputStream code, ArgsMap argsMap) {
        BTraceProbe bp = null;
        try (DataInputStream dis = new DataInputStream(code);){
            dis.mark(0);
            int mgc = dis.readInt();
            if (mgc == -1160852790) {
                BTraceProbePersisted bpp = new BTraceProbePersisted(this);
                bpp.read(dis);
                bp = bpp;
            } else {
                code.reset();
                bp = new BTraceProbeNode(this, code);
            }
        }
        catch (IOException e) {
            log.debug("Failed to create a probe", (Throwable)e);
        }
        BTraceProbeFactory.applyArgs(bp, argsMap);
        HandlerRepositoryImpl.registerProbe(bp);
        return bp;
    }
}

